% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sttc.R
\name{sttc}
\alias{sttc}
\title{Compute STTC for a pair of spike trains}
\usage{
sttc(a, b, dt = 0.05, rec_time = NULL)
}
\arguments{
\item{a}{first spike train}

\item{b}{second spike train}

\item{dt}{bin size in seconds}

\item{rec_time}{2-element vector: start and end time}
}
\value{
STTC a scalar bounded between -1 and +1.
}
\description{
Compute STTC for a pair of spike trains
}
\details{
The Spike Time Tiling correlation (STTC) is computed for a pair
of spike trains.  The method is defined in Cutts and Eglen (2014).
We assume that the spike trains are ordered, smallest-time first.
}
\examples{
a = c(1, 2, 3, 4, 5)
b = a+0.01
c = a+0.5
sttc(a, b)==1
sttc(a, c)==0
}
\author{
Stephen J Eglen
}
