% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shewhart.R
\name{shewhart}
\alias{shewhart}
\alias{shewhart.mds_ts}
\alias{shewhart.default}
\title{Shewhart x-bar Control Chart}
\usage{
shewhart(df, ...)

\method{shewhart}{mds_ts}(df, ts_event = c(Count = "nA"),
  analysis_of = NA, ...)

\method{shewhart}{default}(df, analysis_of = NA, eval_period = NULL,
  zero_rate = 1/3, we_rule = 1L, ...)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{event}{Either the event count or rate of class \code{numeric}}
}}

\item{...}{Further arguments passed onto \code{shewhart} methods}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count or rate. Rate must
be calculated in a separate column in \code{df} as it is not calculated by
default. The name of the string is an English description of what was
analyzed.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.

Example: \code{c("Rate of Bone Filler Events in Canada"="rate")}}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Rate of bone cement leakage"}}

\item{eval_period}{Optional positive integer indicating the number of unique
times counting in reverse chronological order to assess. This will be used to
establish the process mean and moving range.

Default: \code{NULL} considers all times in \code{df}.}

\item{zero_rate}{Required maximum proportion of \code{event}s in \code{df}
(constrained by \code{eval_period}) containing zeroes for this algorithm to
run. Because Shewhart does not perform well on time series with many 0 values,
a value >0 is recommended.

Default: \code{1/3} requires no more than 1/3 zeros in \code{event}s in
\code{df} in order to run.}

\item{we_rule}{Required integer from \code{1} to \code{4} representing the
Western Electric rule to use. See details for descriptions.

Default: \code{1} represents the first Western Electric rule of one point
over the 3-sigma limit.}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the 95%
  confidence bounds, \code{p} for the p-value, \code{signal} status, and
  \code{signal_threshold}.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on device-events using the Shewhart x-bar control chart. Includes
the first 4 Western Electric rules common to statistical process control.
}
\details{
Function \code{shewhart()} is a standard implementation of the x-bar
Control Chart test from the family of statistical process control tests
originally proposed by Walter Shewhart.

\code{we_rule} has four possible values: \code{1} is one point over the
3-sigma limit. \code{2} is two out of three consecutive points over the
2-sigma limit. \code{3} is four of five consecutive points over the 1-sigma
limit. \code{4} is nine consecutive points over the process mean.
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: Shewhart on mds_ts data

\item \code{default}: Shewhart on general data
}}

\examples{
# Basic Example
data <- data.frame(time=c(1:25), event=as.integer(stats::rnorm(25, 100, 25)))
a1 <- shewhart(data)
# Example using an mds_ts object
a2 <- shewhart(mds_ts[[3]])
# Example using a derived rate as the "event"
data <- mds_ts[[3]]
data$rate <- ifelse(is.na(data$nA), 0, data$nA) / data$exposure
a3 <- shewhart(data, c(Rate="rate"))

}
\references{
Montgomery, Douglas C. Introduction to Statistical Quality Control by Douglas C. Montgomery, 5th Edition: Study Guide. Cram101, 2013.
}
