% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{run_algos}
\alias{run_algos}
\title{Run Multiple Algorithms}
\usage{
run_algos(data, algos, dataframe = T)
}
\arguments{
\item{data}{Required input dataset. Note that the dataset must satisfy the
dataset (parameter \code{df}) requirements for each algorithm specified.}

\item{algos}{Input list of algorithms to run. Must be a list generated by
\code{\link{define_algos}}.}

\item{dataframe}{Logical on whether to output results as a
\code{mdsstat_tests} data frame. If \code{FALSE}, will output as a list of
\code{mdsstat_test} lists.

Default: \code{TRUE}}
}
\value{
A \code{mdsstat_tests} data frame or list of \code{mdsstat_test}
lists with the results of the algorithm runs.
}
\description{
Run a multiple number of \code{mdsstat} algorithms on a single input dataset.
}
\examples{
data <- mds_ts[[3]]
data$rate <- data$nA / data$exposure
x <- list(prr=list(),
  shewhart=list(),
  shewhart=list(ts_event=c(Rate="rate"), we_rule=2L),
  poisson_rare=list(p_rate=0.3))
algos <- define_algos(x)
run_algos(data, algos)
run_algos(data, algos, FALSE)
}
