% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webshot.R
\name{save_webshot}
\alias{save_webshot}
\title{Embedded webshot of leaflet map}
\usage{
save_webshot(
  map,
  path_to_img,
  overwrite = FALSE,
  vwidth = 800,
  vheight = 600,
  cliprect = "viewport",
  ...
)
}
\arguments{
\item{map}{A leaflet map object}

\item{path_to_img}{A path to the image file to save}

\item{overwrite}{Do you want to clobber any existing file?}

\item{vwidth}{see \code{\link[webshot2]{webshot}}}

\item{vheight}{see \code{\link[webshot2]{webshot}}}

\item{cliprect}{see \code{\link[webshot2]{webshot}}}

\item{...}{arguments passed to \code{\link[webshot2]{webshot}}}
}
\value{
a path to a PNG file
}
\description{
Embedded webshot of leaflet map
}
\examples{
\dontrun{
if (require(leaflet)) {
  map <- leaflet() \%>\%
    addTiles() \%>\%
    addMarkers(lng = 174.768, lat = -36.852, popup = "The birthplace of R")
  save_webshot(map, tempfile())
}
}
}
