/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram.eps;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JOptionPane;
import multidendrograms.initial.Language;

public class EpsUtils {
    private static String epsFullFileName;
    private static String epsFileName;
    private static FileWriter epsFw;
    private static BufferedWriter epsBw;
    public static int xmin;
    public static int xmax;
    public static int ymin;
    public static int ymax;

    public EpsUtils(int n, int n2, int n3, int n4) {
        xmin = n;
        ymin = n2;
        xmax = n3;
        ymax = n4;
    }

    public static void open(String string) {
        try {
            epsFullFileName = string;
            epsFileName = new File(epsFullFileName).getName();
            epsFw = new FileWriter(epsFullFileName);
            epsBw = new BufferedWriter(epsFw);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = Language.getLabel(106);
            JOptionPane.showMessageDialog(null, string2, "Error", 0);
        }
        catch (IOException iOException) {
            String string3 = Language.getLabel(107);
            JOptionPane.showMessageDialog(null, string3, "Error", 0);
        }
    }

    public static void close() {
        try {
            epsBw.close();
        }
        catch (IOException iOException) {
            String string = Language.getLabel(108) + epsFullFileName;
            JOptionPane.showMessageDialog(null, string, "Error", 0);
        }
    }

    public static void writeComments(String string, String string2) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy  HH:mm:ss");
        EpsUtils.writeLine("%!PS-Adobe-3.0 EPSF-3.0");
        EpsUtils.writeLine("%%Title: " + epsFileName);
        EpsUtils.writeLine("%%Creator: MultiDendrograms 5.0.3  http://deim.urv.cat/~sergio.gomez/multidendrograms.php");
        EpsUtils.writeLine("%%CreationDate: " + simpleDateFormat.format(calendar.getTime()));
        EpsUtils.writeLine("%%BoundingBox: " + xmin + " " + ymin + " " + xmax + " " + ymax);
        EpsUtils.writeLine("%%Orientation: " + string2);
        EpsUtils.writeLine("%%Pages: 1");
        EpsUtils.writeLine("%%EndComments");
        EpsUtils.writeLine("");
    }

    public static void writeProlog(String string) {
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                EpsUtils.writeLine(string2);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            String string3 = Language.getLabel(109) + epsFullFileName;
            JOptionPane.showMessageDialog(null, string3, "Error", 0);
        }
    }

    public static void writeBodyEnd() {
        EpsUtils.writeLine("showpage");
        EpsUtils.writeLine("");
        EpsUtils.writeLine("%%EOF");
    }

    public static void writeLine(String string) {
        try {
            epsBw.write(string + "\n");
        }
        catch (IOException iOException) {
            String string2 = Language.getLabel(108) + epsFullFileName;
            JOptionPane.showMessageDialog(null, string2, "Error", 0);
        }
    }

    public static String setLineWidth(float f) {
        return f + " slw";
    }

    public static String setDashpattern(float[] fArray, int n) {
        String string = new String();
        for (int i = 0; i < fArray.length; ++i) {
            string = string + fArray[i] + " ";
        }
        return string + n + " sdp";
    }

    public static String setRGBColor(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " c";
    }

    public static String setGray(float f) {
        return f + " g";
    }

    public static String stroke() {
        return "s";
    }

    public static String moveTo(float f, float f2) {
        return f + " " + f2 + " m";
    }

    public static String lineTo(float f, float f2) {
        return f + " " + f2 + " l";
    }

    public static String rMoveTo(float f, float f2) {
        return f + " " + f2 + " rm";
    }

    public static String rLineTo(float f, float f2) {
        return f + " " + f2 + " rl";
    }

    public static String dupDup(float f, float f2) {
        return f + " " + f2 + " dup2";
    }

    public static String dupDupDup(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dup3";
    }

    public static String vectorSubstract(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " vsub";
    }

    public static String dCircle(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dci";
    }

    public static String fCircle(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fci";
    }

    public static String oCircle(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " oci";
    }

    public static String dSquare(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dsq";
    }

    public static String fSquare(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fsq";
    }

    public static String oSquare(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " osq";
    }

    public static String dTriangleN(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dtn";
    }

    public static String fTriangleN(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " ftn";
    }

    public static String oTriangleN(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " otn";
    }

    public static String dTriangleW(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dtw";
    }

    public static String fTriangleW(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " ftw";
    }

    public static String oTriangleW(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " otw";
    }

    public static String dTriangleS(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dts";
    }

    public static String fTriangleS(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fts";
    }

    public static String oTriangleS(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " ots";
    }

    public static String dTriangleE(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dte";
    }

    public static String fTriangleE(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fte";
    }

    public static String oTriangleE(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " ote";
    }

    public static String dDiamond(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " ddi";
    }

    public static String fDiamond(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fdi";
    }

    public static String oDiamond(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " odi";
    }

    public static String dPlus(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dpl";
    }

    public static String fPlus(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fpl";
    }

    public static String oPlus(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " opl";
    }

    public static String dTimes(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dxx";
    }

    public static String fTimes(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fxx";
    }

    public static String oTimes(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " oxx";
    }

    public static String dSplat(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " dsp";
    }

    public static String fSplat(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " fsp";
    }

    public static String oSplat(float f, float f2, float f3) {
        return f + " " + f2 + " " + f3 + " osp";
    }

    public static String dRectangle(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " drc";
    }

    public static String fRectangle(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " frc";
    }

    public static String oRectangle(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " orc";
    }

    public static String dLine(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " dli";
    }

    public static String fLine(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " fli";
    }

    public static String oLine(float f, float f2, float f3, float f4) {
        return f + " " + f2 + " " + f3 + " " + f4 + " oli";
    }

    public static String scaleSetFont(String string, float f) {
        return string + " " + f + " fss";
    }

    public static String boundingBoxText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssbb";
    }

    public static String lowercaseBottomTopText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssbt";
    }

    public static String lowerLeftText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssll";
    }

    public static String lowerMiddleText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sslm";
    }

    public static String lowerRightText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sslr";
    }

    public static String middleLeftText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssml";
    }

    public static String middleMiddleText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssmm";
    }

    public static String middleRightText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssmr";
    }

    public static String upperLeftText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssul";
    }

    public static String upperMiddleText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssum";
    }

    public static String upperRightText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssur";
    }

    public static String bottomLeftText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssbl";
    }

    public static String bottomMiddleText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssbm";
    }

    public static String bottomRightText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") ssbr";
    }

    public static String centerLeftText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sscl";
    }

    public static String centerMiddleText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sscm";
    }

    public static String centerRightText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sscr";
    }

    public static String topLeftText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sstl";
    }

    public static String topMiddleText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sstm";
    }

    public static String topRightText(float f, float f2, String string) {
        return f + " " + f2 + " (" + string + ") sstr";
    }

    public static String lowerLeftTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssall";
    }

    public static String lowerMiddleTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssalm";
    }

    public static String lowerRightTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssalr";
    }

    public static String middleLeftTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssaml";
    }

    public static String middleMiddleTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssamm";
    }

    public static String middleRightTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssamr";
    }

    public static String upperLeftTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssaul";
    }

    public static String upperMiddleTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssaum";
    }

    public static String upperRightTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssaur";
    }

    public static String bottomLeftTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssabl";
    }

    public static String bottomMiddleTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssabm";
    }

    public static String bottomRightTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssabr";
    }

    public static String centerLeftTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssacl";
    }

    public static String centerMiddleTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssacm";
    }

    public static String centerRightTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssacr";
    }

    public static String topLeftTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssatl";
    }

    public static String topMiddleTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssatm";
    }

    public static String topRightTextRotated(float f, float f2, float f3, String string) {
        return f + " " + f2 + " " + f3 + " (" + string + ") ssatr";
    }
}

