/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.definitions;

import java.awt.Color;
import java.awt.Font;
import multidendrograms.core.utils.MathUtils;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.LabelOrientation;
import multidendrograms.types.MethodType;
import multidendrograms.types.OriginType;
import multidendrograms.types.ProximityType;

public class SettingsInfo {
    private ProximityType proximityType = ProximityType.DISTANCE;
    private int precision = 0;
    private MethodType method = MethodType.ARITHMETIC_LINKAGE;
    private double methodParameter = 0.0;
    private boolean weighted = false;
    private DendrogramOrientation dendroOrientation = DendrogramOrientation.NORTH;
    private boolean bandVisible = true;
    private Color bandColor = Color.LIGHT_GRAY;
    private int nodeRadius = 0;
    private boolean nodeNameVisible = true;
    private Font nodeNameFont;
    private Color nodeNameColor;
    private LabelOrientation nodeNameOrientation = LabelOrientation.VERTICAL;
    private OriginType originType = OriginType.UNIFORM_ORIGIN;
    private boolean axisVisible = true;
    private Color axisColor = Color.BLACK;
    private double axisMinValue = 0.0;
    private double axisMaxValue = 1.0;
    private double axisIncrement = 0.1;
    private int axisTicks = 10;
    private boolean axisLabelVisible = true;
    private Font axisLabelFont;
    private Color axisLabelColor = Color.BLACK;
    private int axisLabelDecimals = 0;

    public ProximityType getProximityType() {
        return this.proximityType;
    }

    public void setSimilarityType(ProximityType proximityType) {
        this.proximityType = proximityType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public void setMethod(MethodType methodType) {
        this.method = methodType;
    }

    public double getMethodParameter() {
        return this.methodParameter;
    }

    public void setMethodParameter(double d) {
        this.methodParameter = d;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public void setWeighted(boolean bl) {
        this.weighted = bl;
    }

    public DendrogramOrientation getDendrogramOrientation() {
        return this.dendroOrientation;
    }

    public DendrogramOrientation getDendrogramAdaptedOrientation() {
        if (this.proximityType.equals((Object)ProximityType.DISTANCE)) {
            return this.dendroOrientation;
        }
        if (this.dendroOrientation.equals((Object)DendrogramOrientation.NORTH)) {
            return DendrogramOrientation.SOUTH;
        }
        if (this.dendroOrientation.equals((Object)DendrogramOrientation.SOUTH)) {
            return DendrogramOrientation.NORTH;
        }
        if (this.dendroOrientation.equals((Object)DendrogramOrientation.EAST)) {
            return DendrogramOrientation.WEST;
        }
        return DendrogramOrientation.EAST;
    }

    public void setDendrogramOrientation(DendrogramOrientation dendrogramOrientation) {
        this.dendroOrientation = dendrogramOrientation;
    }

    public boolean isBandVisible() {
        return this.bandVisible;
    }

    public void setBandVisible(boolean bl) {
        this.bandVisible = bl;
    }

    public Color getBandColor() {
        return this.bandColor;
    }

    public void setBandColor(Color color) {
        this.bandColor = color;
    }

    public int getNodeRadius() {
        return this.nodeRadius;
    }

    public void setNodeRadius(int n) {
        this.nodeRadius = n;
    }

    public boolean isNodeNameVisible() {
        return this.nodeNameVisible;
    }

    public void setNodeNameVisible(boolean bl) {
        this.nodeNameVisible = bl;
    }

    public Font getNodeNameFont() {
        return this.nodeNameFont;
    }

    public void setNodeNameFont(Font font) {
        this.nodeNameFont = font;
    }

    public Color getNodeNameColor() {
        return this.nodeNameColor;
    }

    public void setNodeNameColor(Color color) {
        this.nodeNameColor = color;
    }

    public LabelOrientation getNodeNameOrientation() {
        return this.nodeNameOrientation;
    }

    public void setNodeNameOrientation(LabelOrientation labelOrientation) {
        this.nodeNameOrientation = labelOrientation;
    }

    public OriginType getOriginType() {
        return this.originType;
    }

    public void setOriginType(OriginType originType) {
        this.originType = originType;
    }

    public boolean isAxisVisible() {
        return this.axisVisible;
    }

    public void setAxisVisible(boolean bl) {
        this.axisVisible = bl;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public double getAxisMinValue() {
        return this.axisMinValue;
    }

    public void setAxisMinValue(double d) {
        this.axisMinValue = d;
    }

    public double getAxisMaxValue() {
        return this.axisMaxValue;
    }

    public void setAxisMaxValue(double d) {
        this.axisMaxValue = d;
    }

    public double getAxisIncrement() {
        return this.axisIncrement;
    }

    public void setAxisIncrement(double d) {
        this.axisIncrement = d;
    }

    public int getAxisNumberOfTicks() {
        double d = (this.axisMaxValue - this.axisMinValue) / this.axisIncrement;
        d = MathUtils.round(d, 6);
        return 1 + (int)d;
    }

    public int getAxisTicks() {
        return this.axisTicks;
    }

    public void setAxisTicks(int n) {
        this.axisTicks = n;
    }

    public boolean isAxisLabelVisible() {
        return this.axisLabelVisible;
    }

    public void setAxisLabelVisible(boolean bl) {
        this.axisLabelVisible = bl;
    }

    public Font getAxisLabelFont() {
        return this.axisLabelFont;
    }

    public void setAxisLabelFont(Font font) {
        this.axisLabelFont = font;
    }

    public Color getAxisLabelColor() {
        return this.axisLabelColor;
    }

    public void setAxisLabelColor(Color color) {
        this.axisLabelColor = color;
    }

    public int getAxisLabelDecimals() {
        return this.axisLabelDecimals;
    }

    public void setAxisLabelDecimals(int n) {
        this.axisLabelDecimals = n;
    }

    public String toString() {
        String string;
        try {
            string = "/// DATA  ///\n";
            string = string + "Data type: " + (Object)((Object)this.getProximityType());
            string = string + "\nPrecision: " + this.getPrecision();
            string = string + "\nMethod: " + (Object)((Object)this.getMethod());
            string = string + "\nWeighted: " + this.isWeighted();
            string = string + "\n\n/// TREE  ///\n";
            string = string + "\nDendrogram orientation: " + (Object)((Object)this.getDendrogramOrientation());
            string = string + "\nBand: " + this.isBandVisible();
            string = string + "\n\n/// NAMES ///\n";
            string = string + "\nNode name: " + this.isNodeNameVisible();
            string = string + "\nNode radius: " + this.getNodeRadius();
            string = string + "\nNode name orientation: " + (Object)((Object)this.getNodeNameOrientation());
            string = string + "\nNode name font: " + this.getNodeNameFont();
            string = string + "\nNode name color: " + this.getNodeNameColor();
            string = string + "\n\n/// AXIS  ///\n";
            string = string + "\nAxis: " + this.isAxisVisible();
            string = string + "\nAxis color" + this.getAxisColor();
            string = string + "\nAxis minimum value: " + Double.toString(this.getAxisMinValue());
            string = string + "\nAxis maximum value: " + Double.toString(this.getAxisMaxValue());
            string = string + "\nAxis increment: " + Double.toString(this.getAxisIncrement());
            string = string + "\nAxis ticks: " + Double.toString(this.getAxisTicks());
            string = string + "\nAxis label: " + this.isAxisLabelVisible();
            string = string + "\nAxis label font: " + this.getAxisLabelFont();
            string = string + "\nAxis label color" + this.getAxisLabelColor();
            string = string + "\nAxis label decimals: " + Integer.toString(this.getAxisLabelDecimals());
        }
        catch (Exception exception) {
            string = "";
        }
        return string;
    }
}

