% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict_recode.R
\name{dict_recode}
\alias{dict_recode}
\title{Recode Missing Values Dictionary-Style}
\usage{
dict_recode(
  df,
  use_func = "recode_na_as",
  pattern_type = "starts_with",
  patterns,
  values
)
}
\arguments{
\item{df}{A data.frame object for which recoding is to be done.}

\item{use_func}{Function to use for the recoding. One of the various 
`recode_*` functions in package `mde`.}

\item{pattern_type}{One of contains', 'starts_with' or 'ends_with'.}

\item{patterns}{A vector containing patterns to use for pattern_type}

\item{values}{A vector containing values to match to the patterns vector}
}
\value{
A `data.frame` object with replacements as required.
}
\description{
Recode Missing Values Dictionary-Style
}
\examples{
head(dict_recode(airquality, pattern_type="starts_with",
patterns = c("Solar", "Ozone"), values = c(190, 41),
use_func="recode_as_na"))
 head(dict_recode(airquality, pattern_type="starts_with",
patterns = c("Solar", "Ozone"), values = c(42, 420),
use_func="recode_na_as"))
}
