% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_time.R
\name{round_time}
\alias{round_time}
\alias{round_time.Duration}
\alias{round_time.difftime}
\alias{round_time.hms}
\alias{round_time.POSIXct}
\alias{round_time.POSIXlt}
\title{Round time objects}
\usage{
round_time(x)

\method{round_time}{Duration}(x)

\method{round_time}{difftime}(x)

\method{round_time}{hms}(x)

\method{round_time}{POSIXct}(x)

\method{round_time}{POSIXlt}(x)
}
\arguments{
\item{x}{An object belonging to one of the following classes:
\code{\link[lubridate:duration]{Duration}}, \code{\link[base:difftime]{difftime}},
\code{\link[hms:hms]{hms}}, \code{\link[base:as.POSIXlt]{POSIXct}}, or
\code{\link[base:as.POSIXlt]{POSIXlt}}.}
}
\value{
An object of the same class of \code{x} rounded at the seconds level.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{round_time()} takes a \code{\link[lubridate:duration]{Duration}},
\code{\link[base:difftime]{difftime}}, \code{\link[hms:hms]{hms}},
\code{\link[base:as.POSIXlt]{POSIXct}}, or \code{\link[base:as.POSIXlt]{POSIXlt}} object
and round it at the seconds level.
}
\details{
\subsection{Round standard}{

\code{round_time()} uses \code{\link[base:Round]{base::round()}} for rounding. That is to say that
\code{round_time()} uses the same IEC 60559 standard (\emph{"go to the even digit"})
for rounding off a 5. Therefore, \code{round(0.5)} is equal to 0 and \code{round(-1.5)}
is equal to -2. See \code{\link[base:Round]{?round}} to learn more.
}

\subsection{\code{Period} objects}{

\code{\link[lubridate:period]{Period}} objects are special type of objects
developed by the \link[lubridate:lubridate-package]{lubridate} team that
represents "human units", ignoring possible timeline irregularities. That is
to say that 1 day as \code{Period} can have different time spans, when looking to
a timeline after a irregularity event.

Since the time span of a \code{\link[lubridate:period]{Period}} object can
fluctuate, \code{round_time()} don't accept this kind of object. You can transform
it to a \code{\link[lubridate:duration]{Duration}} object and still use the
function, but beware that this can produce errors.

Learn more about \code{\link[lubridate:period]{Period}} objects in the \href{https://r4ds.had.co.nz/dates-and-times.html#periods}{Dates and times} chapter of
Wickham & Grolemund book (n.d.).
}
}
\examples{
## Scalar example

lubridate::dmilliseconds(123456789)
#> [1] "123456.789s (~1.43 days)" # Expected
round_time(lubridate::dmilliseconds(123456789))
#> [1] "123457s (~1.43 days)" # Expected

as.difftime(12345.6789, units = "secs")
#> Time difference of 12345.68 secs # Expected
round_time(as.difftime(12345.6789, units = "secs"))
#> Time difference of 12346 secs # Expected

hms::as_hms(12345.6789)
#> 03:25:45.6789 # Expected
round_time(hms::as_hms(12345.6789))
#> 03:25:46 # Expected

lubridate::as_datetime(12345.6789, tz = "EST")
#> [1] "1969-12-31 22:25:45 EST" # Expected
as.numeric(lubridate::as_datetime(12345.6789, tz = "EST"))
#> [1] 12345.68 # Expected
round_time(lubridate::as_datetime(12345.6789, tz = "EST"))
#> [1] "1969-12-31 22:25:46 EST" # Expected
as.numeric(round_time(lubridate::as_datetime(12345.6789, tz = "EST")))
#> [1] 12346 # Expected

## Vector example

c(lubridate::dhours(5.6987), lubridate::dhours(2.6875154))
#> [1] "20515.32s (~5.7 hours)"    "9675.05544s (~2.69 hours)" # Expected
round_time(c(lubridate::dhours(5.6987), lubridate::dhours(2.6875154)))
#> [1] "20515s (~5.7 hours)" "9675s (~2.69 hours)" # Expected
}
\references{
Wickham, H., & Grolemund, G. (n.d.). \emph{R for data science}. Sebastopol, CA:
O'Reilly Media. \url{https://r4ds.had.co.nz}
}
\seealso{
Other date-time rounding functions:
\code{\link[hms:round_hms]{round_hms()}} \code{\link[hms:round_hms]{trunc_hms()}}
\code{\link[lubridate:round_date]{round_date()}}.

Other utility functions: 
\code{\link{assign_date}()},
\code{\link{cycle_time}()},
\code{\link{pretty_mctq}()},
\code{\link{qplot_walk}()},
\code{\link{random_mctq}()},
\code{\link{raw_data}()},
\code{\link{shorter_interval}()},
\code{\link{sum_time}()}
}
\concept{utility functions}
