% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmsupply.R
\docType{package}
\name{mcmsupply-package}
\alias{mcmsupply}
\alias{mcmsupply-package}
\title{mcmsupply: Estimating Public and Private Sector Contraceptive Market Supply Shares}
\description{
Family Planning programs and initiatives typically use nationally representative surveys to estimate key indicators of a country’s family planning progress. However, in recent years, routinely collected family planning services data (Service Statistics) have been used as a supplementary data source to bridge gaps in the surveys. The use of service statistics comes with the caveat that adjustments need to be made for missing private sector contributions to the contraceptive method supply chain. Evaluating the supply source of modern contraceptives often relies on Demographic Health Surveys (DHS), where many countries do not have recent data beyond 2015/16. Fortunately, in the absence of recent surveys we can rely on statistical model-based estimates and projections to fill the knowledge gap. We present a Bayesian, hierarchical, penalized-spline model with multivariate-normal spline coefficients, to account for across method correlations, to produce country-specific,annual estimates for the proportion of modern contraceptive methods coming from the public and private sectors. This package provides a quick and convenient way for users to access the DHS modern contraceptive supply share data at national and subnational administration levels, estimate, evaluate and plot annual estimates with uncertainty for a sample of low- and middle-income countries. Methods for the estimation of method supply shares at the national level are described in Comiskey, Alkema, Cahill (2022) \href{https://arxiv.org/abs/2212.03844}{arXiv:2212.03844}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://hannahcomiskey.github.io/mcmsupply/}
  \item \url{https://hannahcomiskey.github.io/mcmsupply/}
}

}
\author{
\strong{Maintainer}: Hannah Comiskey \email{hannah.comiskey.2015@mumail.ie}

Authors:
\itemize{
  \item Niamh Cahill
  \item Leontine Alkema
}

}
\keyword{internal}
