% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_posterior_P_samps.R
\name{get_posterior_P_samps}
\alias{get_posterior_P_samps}
\title{Function to pull the complete posterior sample for the national method-supply share estimates. Functionality for the subnational models is still under development.}
\usage{
get_posterior_P_samps(jagsdata, model_output, nposterior)
}
\arguments{
\item{jagsdata}{The inputs for the JAGS model}

\item{model_output}{The output of the mcmsupply::run_jags_model() function.}

\item{nposterior}{The number of posterior samples you wish to pull.}
}
\value{
A dataframe containing the posterior samples of national method-supply share estimates.
}
\description{
Function to pull the complete posterior sample for the national method-supply share estimates. Functionality for the subnational models is still under development.
}
\examples{
\dontrun{
raw_data <- get_data(national=TRUE, local=TRUE, mycountry="Nepal")
jagsdata <- get_modelinputs(startyear=1990, endyear=2025.5, nsegments=12, raw_data)
mod <- run_jags_model(jagsdata = jagsdata, jagsparams = NULL, n_iter = 5, n_burnin = 1, n_thin = 1)
post_samps <- get_posterior_P_samps(jagsdata = jagsdata, model_output = mod, nposterior=4)
}
}
