% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_gl.R
\name{glreg}
\alias{glreg}
\title{Create a model object for group-level regression effects within a
generic random effects component.}
\usage{
glreg(
  formula = NULL,
  remove.redundant = FALSE,
  prior = NULL,
  Q0 = NULL,
  data = NULL,
  name = ""
)
}
\arguments{
\item{formula}{a formula specifying the group-level predictors to be used within a model
component. If no \code{data} is supplied the group-level predictors are derived as
group-level means from the unit-level data passed as \code{data} argument to
\code{\link{create_sampler}} or \code{\link{generate_data}}.}

\item{remove.redundant}{whether redundant columns should be removed from the design matrix.
Default is \code{FALSE}.}

\item{prior}{prior specification for the group-level effects. Currently only
normal priors with mean 0 can be specified, using function \code{\link{pr_normal}}.}

\item{Q0}{prior precision matrix for the group-level effects. The default is a
zero matrix corresponding to a noninformative improper prior.
DEPRECATED, please use argument \code{prior} instead, i.e.
\code{prior = pr_normal(precision = Q0.value)}.}

\item{data}{group-level data frame in which the group-level variables specified in
\code{formula} are looked up.}

\item{name}{the name of the model component. This name is used in the output of the
MCMC simulation function \code{\link{MCMCsim}}. By default this name will be
the name of the corresponding generic random effects component appended by '_gl'.}
}
\value{
An object with precomputed quantities for sampling from
 prior or conditional posterior distributions for this model component. Only intended
 for internal use by other package functions.
}
\description{
This function is intended to be used to specify the \code{formula.gl} argument to
the \code{\link{gen}} model component specification function.
Group-level predictors and hierarchical centring are
not used by default, and they currently cannot be used in a model component that is sampled
together with another model component in the same Gibbs block.
}
