% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_exp.R
\name{.cor_exp}
\alias{.cor_exp}
\title{Calculate exponential correlation}
\usage{
.cor_exp(x, c, gamma = 1/2, nugget = 0)
}
\arguments{
\item{x}{A numeric vector, matrix, or array.}

\item{c}{Smooth parameter, \eqn{c>0}.}

\item{gamma}{Scale parameter, \eqn{\gamma\in(0, 1/2]}. Default is 1/2.}

\item{nugget}{The nugget effect \eqn{\in[0, 1]}.}
}
\value{
Correlations of the same dimension as \code{x}.
}
\description{
Calculate exponential correlation
}
\details{
The exponential correlation function with scale parameter \eqn{c}
and smooth parameter \eqn{\gamma} has the form
\deqn{C(x)=(1-\text{nugget})\exp(-c|x|^{2\gamma})+\text{nugget}\cdot
\delta_{x=0},} where \eqn{\delta_{x=0}} is 1 when \eqn{x=0} and 0 otherwise.
}
\references{
Diggle, P. J., Tawn, J. A., & Moyeed, R. A. (1998). Model-Based
Geostatistics. Journal of the Royal Statistical Society. Series C (Applied
Statistics), 47(3), 299–350.
}
\keyword{internal}
