% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbsts_class.R
\docType{class}
\name{mbsts-class}
\alias{mbsts-class}
\title{Constructor for the MBSTS model}
\description{
This class constructor build an object of MBSTS class, encoding a state space model together with a uni- or multi-variate time series, which is central to all the package's functionality. One implements the MBSTS model by specifying some or all of its basic components.
}
\section{Slots}{

\describe{
\item{\code{Xtrain}}{A (\eqn{n*K})-dimensional matrix containing all candidate predictor series for each target series. \eqn{K=\sum k_i} is the number of all candidate predictors for all target series. The first \eqn{k_1} variables are the set of candidate predictors for the first target series, and the next \eqn{k_2} variables are the set of candidate predictors for the second target series, etc. Note that, one variable can appear in the X.star several times, since different target series can contain the same candidate predictors.}

\item{\code{Ind}}{A (\eqn{K*}(mc-burn))-dimensional matrix containing MCMC draws of the indicator variable. If X.star is null, it will not be returned.}

\item{\code{beta.hat}}{A (\eqn{K*}(mc-burn))-dimensional matrix containing MCMC draws of regression coefficients. If X.star is null, it will not be returned.}

\item{\code{B.hat}}{A (\eqn{K*m*}(mc-burn))-dimensional array generated by combining beta.hat for all target series. If X.star is null, it will not be returned.}

\item{\code{ob.sig2}}{A (\eqn{m*m*}(mc-burn))-dimensional array containing MCMC draws of variance-covariance matrix for residuals.}

\item{\code{States}}{A (\eqn{n*m1*}(mc-burn))-dimensional array containing MCMC draws of all time series components, where \eqn{m1} is the number of all time series components. If the STmodel is null, it will not be returned.}

\item{\code{st.sig2}}{A (\eqn{K*}(mc-burn))-dimensional matrix containing MCMC draws of variances for time series components. If the STmodel is null, it will not be returned.}

\item{\code{ki}}{A vector of integer values denoting the acumulated number of predictors for target series. For example, if there are three target series where the first has \eqn{8} predictors, the second has \eqn{6} predictors, and the third has \eqn{10} predictors, then the vector is c(\eqn{8,14,24}).}

\item{\code{ntrain}}{A numerical value for number of observations.}

\item{\code{mtrain}}{A numerical value for number of response variables.}
}}

\references{
\Ning2021
}
\author{
Jinwen Qiu \email{qjwsnow_ctw@hotmail.com} Ning Ning \email{patricianing@gmail.com}
}
