% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{diag_par}
\alias{diag_par}
\title{Diagonal partition given break dates}
\usage{
diag_par(input, m, date)
}
\arguments{
\item{input}{matrix of independent variables z with coefficients allowed to
change overtime}

\item{m}{number of breaks in the series}

\item{date}{vector of break dates}
}
\value{
output: matrix of partitioned variables corresponds to break dates
}
\description{
\code{diag_par()} partition the matrix of \code{z} regressors which coefficients are changed
based on the provided break dates
}
\examples{
z = matrix(c(1:100),50,2)
m = 2  #2 breaks
date = matrix(c(15,30),2,1) #first break at t = 15; second break at t = 30
diag_par(z,m,date)

}
