% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_e.R
\name{mle_e}
\alias{mle_e}
\title{MLE of e for fixed p}
\usage{
mle_e(
  tab,
  p = 0.05,
  interval = c(0, 1),
  tol = 0.000001,
  check_boundary = FALSE
)
}
\arguments{
\item{tab}{Dataset of read counts as 3d array of size 3x3x2, genotype in first sample x genotype in second sample x allele in read.}

\item{p}{Assumed value for the contaminant probability}

\item{interval}{Interval to which each parameter should be constrained}

\item{tol}{Tolerance for convergence}

\item{check_boundary}{If TRUE, explicitly check the boundaries of \code{interval}.}
}
\value{
A single numeric value, the MLE of \code{e}, with the log likelihood as an attribute.
}
\description{
Calculate the MLE of the sequencing error rate e for a fixed value of the contaminant probability p.
}
\examples{
data(mbmixdata)
mle_e(mbmixdata, p=0.74)

}
