\name{iascagpcp}
\alias{iascagpcp}

\title{
Interactive parallel coordinate plots for exploring scagnostics results 
}
\description{
An interactive parallel coordinate plot for exploring scagnostics results programmed with the package \pkg{shiny}. If \code{sdfdata} is generated by function \code{\link{sdf}},  \emph{Outliers} and  \emph{Exemplars} can be explored separately. Selections within the parallel coordinate plot can be made by drawing boxes on the axes around the chosen line.  
}
\usage{
iascagpcp(sdfdata)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{sdfdata}{
A list of class \code{"sdfdata"}. 
}
}
\details{
For scaling the three options 'std' (every scagnostic individually by subtraction of mean and division by  standard deviation), 'uniminmax' (every scagnostic individually to unit interval) and 'globalminmax' (no scaling) can be used. See also \code{\link[GGally]{ggparcoord}}. 
}
\value{
A shiny app object. 
}
\references{
W. Chang, J. Cheng, J. Allaire, Y. Xie and J. McPherson (2016) shiny: Web Application Framework for R. \url{https://cran.r-project.org/package=shiny}.

B. Schloerke et al. (2016) GGally: Extension to ggplot2. \url{https://cran.r-project.org/package=GGally}
}

\author{
Katrin Grimm
}

\seealso{
\code{\link{sdf}}, \code{\link{scag2sdf}}
}
\examples{
\dontrun{
data(Election2005)
# some demographic/economic variables 
sdfdata <- sdf(Election2005[,5:40])
iascagpcp(sdfdata) 
}
}
\keyword{interactive apps}