% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sierpinski_carpet_maze.r
\name{sierpinski_carpet_maze}
\alias{sierpinski_carpet_maze}
\title{sierpinski_carpet_maze .}
\usage{
sierpinski_carpet_maze(unit_len, height, width = height, angle = 90,
  clockwise = TRUE, method = "random", color1 = "black",
  color2 = "gray40", start_from = c("midpoint", "corner"), balance = 0,
  draw_boundary = FALSE, num_boundary_holes = 2, boundary_lines = TRUE,
  boundary_holes = NULL, boundary_hole_color = NULL,
  boundary_hole_locations = NULL, boundary_hole_arrows = FALSE,
  end_side = 1)
}
\arguments{
\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{height}{the length of the first side in numbers of \code{unit_len}
segments.}

\item{width}{the length of the second side in numbers of \code{unit_len}
segments.}

\item{angle}{the angle (in degrees) between the first and second sides.}

\item{clockwise}{whether to draw clockwise.}

\item{method}{passed to \code{\link{parallelogram_maze}} to control the method
of drawing the sub mazes.}

\item{color1}{The dominant color of the maze.}

\item{color2}{The negative color of the maze.}

\item{start_from}{whether to start from the midpoint of the first side
of a maze, or from the corner facing the first side.}

\item{balance}{passed to \code{\link{parallelogram_maze}} to
control imbalance of sub mazes.}

\item{draw_boundary}{a boolean indicating whether a final boundary shall be
drawn around the maze.}

\item{num_boundary_holes}{the number of boundary sides which should be
randomly selected to have holes. Note that the \code{boundary_holes}
parameter takes precedence.}

\item{boundary_lines}{indicates which of the sides of the maze
shall have drawn boundary lines. Can be a logical array indicating
which sides shall have lines, or a numeric array, giving the
index of sides that shall have lines.}

\item{boundary_holes}{an array indicating which of the boundary lines
have holes. If \code{NULL}, then boundary holes are randomly selected
by the \code{num_boundary_holes} parameter. If numeric, indicates
which sides of the maze shall have holes. If a boolean array, indicates
which of the sides shall have holes. These forms are recycled
if needed. See \code{\link{holey_path}}. Note that if no line
is drawn, no hole can be drawn either.}

\item{boundary_hole_color}{the color of boundary holes. A value of
\code{NULL} indicates no colored holes. See \code{\link{holey_path}}
for more details. Can be an array of colors, or colors and the 
value \code{'clear'}, which stands in for \code{NULL} to
indicate no filled hole to be drawn.}

\item{boundary_hole_locations}{the \sQuote{locations} of the boundary holes
within each boundary segment.
A value of \code{NULL} indicates the code may randomly choose, as is
the default.
May be a numeric array. A positive value up to the side length is
interpreted as the location to place the boundary hole.
A negative value is interpreted as counting down from the side
length plus 1. A value of zero corresponds to allowing the 
code to pick the location within a segment.
A value of \code{NA} may cause an error.}

\item{boundary_hole_arrows}{a boolean or boolean array indicating whether to draw
perpendicular double arrows at the boundary holes, as a visual guide. These
can be useful for locating the entry and exit points of a maze.}

\item{end_side}{the number of the side to end on. A value of
1 corresponds to the starting side, while higher numbers
correspond to the drawn side of the figure in the canonical order
(that is, the order induced by the \code{clockwise} parameter).}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Recursively draw a Sierpinski carpet maze in a parallelogram,
with the first side consisting of
\code{height} segments of length \code{unit_len}, and the second side 
\code{width} segments of length \code{unit_len}. The angle between
the first and second side may be set.
}
\details{
Draws a Sierpinski carpet as two-color maze in a parallelogram.
}
\examples{
library(TurtleGraphics)
turtle_init(800,900,mode='clip')
turtle_hide()
turtle_up()
turtle_do({
 turtle_setpos(35,400)
 turtle_setangle(0)
 sierpinski_carpet_maze(angle=80,unit_len=8,width=30,height=30,
   method='two_parallelograms',draw_boundary=TRUE,balance=-1.0,color2='green')
})

\dontrun{
library(TurtleGraphics)
turtle_init(2000,2000,mode='clip')
turtle_hide()
turtle_up()
bholes <- list(c(1,2), c(1), c(2))
turtle_do({
 turtle_setpos(1000,1100)
 turtle_setangle(180)
 for (iii in c(1:3)) {
	 mybhol <- bholes[[iii]]
	 sierpinski_carpet_maze(angle=120,unit_len=12,width=81,height=81,
		 draw_boundary=TRUE,boundary_lines=c(1,2,3),num_boundary_holes=0,
		 boundary_holes=mybhol,balance=1.0,color2='green',
		 start_from='corner')
	 turtle_left(120)
 }
})
}
}
\seealso{
\code{\link{parallelogram_maze}},
\code{\link{sierpinski_maze}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
