% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{group_by_everything_except}
\alias{group_by_everything_except}
\title{Group by all variables except some}
\usage{
group_by_everything_except(.DF, ..., .add = FALSE, .drop = FALSE)
}
\arguments{
\item{.DF}{a data frame to be grouped}

\item{...}{a string, strings, vector of strings, or list of strings representing column names to be excluded from grouping}

\item{.add}{When `.add = FALSE`, the default, `dplyr::group_by()` will override existing groups.
To add to the existing groups, use `.add = TRUE`.}

\item{.drop}{When `.drop = TRUE`, empty groups are dropped.}
}
\value{
a grouped version of `.DF`
}
\description{
This is a convenience function
that allows grouping of a data frame by all variables (columns)
except those variables specified in `...`.
}
\examples{
library(dplyr)
DF <- data.frame(a = c(1, 2), b = c(3, 4), c = c(5, 6))
group_by_everything_except(DF) \%>\% group_vars()
group_by_everything_except(DF, NULL) \%>\% group_vars()
group_by_everything_except(DF, c()) \%>\% group_vars()
group_by_everything_except(DF, list()) \%>\% group_vars()
group_by_everything_except(DF, c) \%>\% group_vars()
group_by_everything_except(DF, "a") \%>\% group_vars()
group_by_everything_except(DF, "c") \%>\% group_vars()
group_by_everything_except(DF, c("a", "c")) \%>\% group_vars()
group_by_everything_except(DF, c("a")) \%>\% group_vars()
group_by_everything_except(DF, list("a")) \%>\% group_vars()
}
