% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{identize_byname}
\alias{identize_byname}
\title{Named identity matrix or vector}
\usage{
identize_byname(a, margin = c(1, 2))
}
\arguments{
\item{a}{the matrix whose names and dimensions are to be preserved in an identity matrix or vector}

\item{margin}{determines whether an identity vector or matrix is returned. See details.}
}
\value{
An identity matrix or vector.
}
\description{
Creates an identity matrix (\strong{I}) or vector (\strong{i}) of same size and with same names and
same row and column types as \code{a}.
If \code{margin = 1}, makes a column matrix filled with \code{1}s.
Row names and type are taken from row names and type of \code{a}.
Column name and type are same as column type of \code{a}.
If \code{margin = 2}, make a row matrix filled with \code{1}s.
Column names and type are taken from column name and type of \code{a}.
Row name and type are same as row type of \code{a}.
If \code{c(1,2)} (the default), make an identity matrix with \code{1}s on the diagonal.
Row and column names are sorted on output.
}
\examples{
M <- matrix(1:16, ncol = 4, dimnames=list(c(paste0("i", 1:4)), paste0("c", 1:4))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
identize_byname(M)
identize_byname(M, margin = c(1,2))
identize_byname(M, margin = 1)
identize_byname(M, margin = 2)
N <- matrix(c(-21, -12, -21, -10), ncol = 2, dimnames = list(c("b", "a"), c("b", "a"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
identize_byname(N)
# This also works with lists
identize_byname(list(M, M))
}
