% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Unary.R
\name{Iminus_byname}
\alias{Iminus_byname}
\title{Subtract a matrix with named rows and columns from a suitably named and sized identity matrix (\code{I})}
\usage{
Iminus_byname(a)
}
\arguments{
\item{a}{the matrix to be subtracted from \code{I}}
}
\value{
The difference between an identity matrix (\code{I}) and \code{m}
(whose rows and columns have been completed and sorted)
}
\description{
The order of rows and columns of \code{m} may change before subtracting from \code{I},
because the rows and columns are sorted by name prior to subtracting from \code{I}.
Furthermore, if \code{m} is not square, it will be made square
before subtracting from \code{I} by calling \code{complete_and_sort}.
}
\examples{
m <- matrix(c(-21, -12, -21, -10), ncol = 2, dimnames = list(c("b", "a"), c("b", "a"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
# Rows and columns are unsorted
diag(1, nrow = 2) - m 
# Rows and columns are sorted prior to subtracting from the identity matrix
Iminus_byname(m) 
# This also works with lists
Iminus_byname(list(m,m))
# If the m is not square before subtracting from I,
# it will be made square by the function complete_and_sort.
m2 <- matrix(c(1,2,3,4,5,6), ncol = 2, dimnames = list(c("a", "b", "c"), c("a", "b"))) \%>\%
  setrowtype("Industries") \%>\% setcoltype("Commodities")
Iminus_byname(m2)
}
