% Generated by roxygen2 (4.0.2): do not edit by hand
\name{inner.identity}
\alias{inner.identity}
\title{PLS inner estimation with the identity scheme}
\usage{
inner.identity(S, W, inner.mod, ...)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{W}{Weight matrix, where the indicators are on colums and composites are on the rows.}

\item{inner.mod}{A square matrix specifying the relationships of the composites in the model.}

\item{...}{Other parameters are ignored}
}
\value{
A matrix of unscaled inner weights \code{E} with the same dimesions as \code{inner.mod}.
}
\description{
Returns a set of inner weights using the identity scheme.
}
\details{
This scheme is not commonly discussed in the current PLS literature, but it is a special case
that is analyzed in the early PLS literature and currently implemented in at least the WarpPLS software.
In the identity scheme identity matrix is used as the inner weight matrix \code{E}.

The identity scheme with Mode A outer estimation converges toward the first principal component of each indicator block.
}
\references{
Wold, H. (1966). Nonlinear estimation by iterative least squares procedures. \emph{Research Papers in Statistics: Festschrift for J. Neyman}, 411–444.

Wold, H. (1982). Soft modeling - The Basic Design And Some Extensions. In K. G. Jöreskog & S. Wold (Eds.), \emph{Systems under indirect observation: causality, structure, prediction} (pp. 1–54). Amsterdam: North-Holland.
}
\seealso{
Other inner estimators: \code{\link{inner.GSCA}};
  \code{\link{inner.Horst}}; \code{\link{inner.centroid}};
  \code{\link{inner.factor}}; \code{\link{inner.path}}
}

