% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttest.R
\name{ttest}
\alias{ttest}
\alias{row_t_onesample}
\alias{col_t_onesample}
\alias{row_t_equalvar}
\alias{col_t_equalvar}
\alias{row_t_welch}
\alias{col_t_welch}
\alias{row_t_paired}
\alias{col_t_paired}
\title{t-test}
\usage{
row_t_onesample(x, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

col_t_onesample(x, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

row_t_equalvar(x, y, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

col_t_equalvar(x, y, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

row_t_welch(x, y, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

col_t_welch(x, y, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

row_t_paired(x, y, alternative = "two.sided", mu = 0,
  conf.level = 0.95)

col_t_paired(x, y, alternative = "two.sided", mu = 0,
  conf.level = 0.95)
}
\arguments{
\item{x}{numeric matrix.}

\item{alternative}{alternative hypothesis to use for each row/column of x.
A single string or a vector with values for each observation.
Values must be one of "two.sided" (default), "greater" or "less".}

\item{mu}{true values of the means for the null hypothesis.
A single number or numeric vector with values for each observation.}

\item{conf.level}{confidence levels used for the confidence intervals.
A single number or a numeric vector with values for each observation.
All values must be in the range of [0;1].}

\item{y}{numeric matrix for the second group of observations.}
}
\value{
a data.frame where each row contains the results of a t.test
performed on the corresponding row/column of x.
The columns will vary depending on the type of test performed.\cr\cr
They will contain a subset of the following information:\cr
1. obs.x - number of x observations\cr
2. obs.y - number of y observations\cr
3. obs.tot - total number of observations\cr
4. obs.paired - number of paired observations (present in x and y)\cr
5. mean.x - mean estiamte of x\cr
6. mean.y - mean estiamte of y\cr
7. mean.diff - mean estiamte of x-y difference\cr
8. var.x - variance estiamte of x\cr
9. var.y - variance estiamte of y\cr
10. var.diff - variance estiamte of x-y difference\cr
11. var.pooled - pooled variance estimate of x and y\cr
12. stderr - standard error\cr
13. df - degrees of freedom\cr
14. statistic - t statistic\cr
15. pvalue - p-value\cr
16. conf.low - lower bound of the confidence interval\cr
17. conf.high - higher bound of the confidence interval\cr
18. alternative - chosen alternative hypothesis\cr
19. mean.null - mean of the null hypothesis\cr
20. conf.level - chosen confidence level
}
\description{
Performs a t-test on each row/column of a the input matrix.
}
\details{
Functions to perform one sample and two sample t-tests for rows/columns of matrices.
Main arguments and results were intentionally matched to the \code{t.test()}
function from default stats package. Other arguments were split into separate
functions:

\code{row_t_onesample(x)} - one sample t-test on rows.
\code{col_t_onesample(x)} - one sample t-test on columns.

Results should be the same as running \code{t.test(x)}
on every row (or column) of \code{x}.

\code{row_t_equalvar(x, y)} - two sample equal variance t-test on rows.
\code{col_t_equalvar(x, y)} - two sample equal variance t-test on columns.

Results should be the same as running \code{t.test(x, y, var.equal=TRUE)}
on every row (or column) of \code{x} and \code{y}.

\code{row_t_welch(x, y)} - two sample t-test with Welch correction on rows.
\code{col_t_welch(x, y)} - two sample t-test with Welch correction on columns.

Results should be the same as running \code{t.test(x, y)}
on every row (or column) of \code{x} and \code{y}.

\code{row_t_paired(x, y)} - two sample paired t-test on rows.
\code{col_t_paired(x, y)} - two sample paired t-test on columns.

Results should be the same as running \code{t.test(x, y, paired=TRUE)}
on every row (or column) of \code{x} and \code{y}.
}
\examples{
X <- iris[iris$Species=="setosa",1:4]
Y <- iris[iris$Species=="virginica",1:4]
col_t_welch(X, Y)

# same row using different confidence levels
col_t_equalvar(X[,c(1,1,1)], Y[,c(1,1,1)], conf.level=c(0.9, 0.95, 0.99))

}
\seealso{
\code{t.test()}
}
\author{
Karolis Koncevičius
}
