% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2.R
\name{mean2}
\alias{mean2}
\title{Fast averaging over subset of vector elements}
\usage{
mean2(x, idxs = NULL, na.rm = FALSE, refine = TRUE, ...)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{idxs}{A \code{\link[base]{vector}} indicating subset of elements to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{refine}{If \code{\link[base:logical]{TRUE}} and \code{x} is
\code{\link[base]{numeric}}, then extra effort is used to calculate the
average with greater numerical precision, otherwise not.}

\item{...}{Not used.}
}
\value{
Returns a \code{\link[base]{numeric}} scalar.
}
\description{
Computes the sample mean of all or a subset of values.
}
\details{
\code{mean2(x, idxs)} gives equivalent results as \code{mean(x[idxs])},
but is faster and more memory efficient since it avoids the actual
subsetting which requires copying of elements and garbage collection
thereof.

If \code{x} is \code{\link[base]{numeric}} and \code{refine = TRUE}, then a
two-pass scan is used to calculate the average.  The first scan calculates
the total sum and divides by the number of (non-missing) values.  In the
second scan, this average is refined by adding the residuals towards the
first average.  The \code{\link[base]{mean}}() uses this approach.
\code{mean2(..., refine = FALSE)} is almost twice as fast as
\code{mean2(..., refine = TRUE)}.
}
\examples{
x <- 1:10
n <- length(x)

idxs <- seq(from = 1, to = n, by = 2)
s1 <- mean(x[idxs])                     # 25
s2 <- mean2(x, idxs = idxs)             # 25
stopifnot(identical(s1, s2))

idxs <- seq(from = n, to = 1, by = -2)
s1 <- mean(x[idxs])                     # 25
s2 <- mean2(x, idxs = idxs)             # 25
stopifnot(identical(s1, s2))

s1 <- mean(x)                           # 55
s2 <- mean2(x)                          # 55
stopifnot(identical(s1, s2))
}
\seealso{
\code{\link[base]{mean}}().
To efficiently sum over a subset, see \code{\link{sum2}}().
}
\author{
Henrik Bengtsson
}
\keyword{internal}
\keyword{univar}
