% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_read-write.R
\name{sim_read}
\alias{sim_read}
\title{Read similarity matrix.}
\usage{
sim_read(input, file_format = "parquet")
}
\arguments{
\item{input}{character string specifying the input filename or directory.}

\item{file_format}{character string specify file format. This must be one of \code{csv} or \code{parquet}(default).}
}
\value{
\code{metric_sim} object.
}
\description{
\code{sim_read} reads similarity matrix.
}
\examples{
suppressMessages(suppressWarnings(library(magrittr)))
population <- tibble::tibble(
  Metadata_group = sample(c("a", "b"), 4, replace = TRUE),
  x = rnorm(4),
  y = x + rnorm(4) / 100,
  z = y + rnorm(4) / 1000
)
tmpdir <- tempdir()
tmpfile_prefix <- file.path(tmpdir, "test")
tmpfile_parquet <- file.path(tmpdir, "test.pqrquet")
sim_df <- sim_calculate(population, method = "pearson")
sim_df \%>\% sim_write(tmpfile_prefix, file_format = "csv")
sim_df_csv <- sim_read(tmpfile_prefix, file_format = "csv")
sim_df \%>\% sim_write(tmpfile_parquet)
sim_df_parquet1 <- sim_read(tmpfile_parquet)
sim_df \%>\% arrow::write_parquet(tmpfile_parquet)
sim_df_parquet2 <- arrow::read_parquet(tmpfile_parquet)
all(sim_df_parquet1 == sim_df_parquet2)
all(sim_df_parquet1 == sim_df_csv)
}
