% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corner.R
\name{corner}
\alias{corner}
\title{Draw a corner showing the angle between two vectors}
\usage{
corner(p1, p2, p3, d = 0.1, absolute = TRUE, ...)
}
\arguments{
\item{p1}{Starting point of first vector}

\item{p2}{End point of first vector, and also start of second vector}

\item{p3}{End point of second vector}

\item{d}{The distance from \code{p2} along each vector for drawing their corner}

\item{absolute}{logical; if \code{TRUE}, \code{d} is taken as an absolute distance along the vectors; otherwise it
is calculated as a relative distance, i.e., a fraction of the length of the vectors.
See \code{\link{pointOnLine}} for the precise definition.}

\item{...}{Arguments passed to \code{link[graphics]{lines}} or to \code{link[rgl]{lines3d}}}
}
\value{
none
}
\description{
A utility function for drawing vector diagrams. Draws two line segments to indicate the angle between two vectors,
typically used for indicating orthogonal vectors are at right angles in 2D and 3D diagrams.
}
\details{
In this implementation, the two vectors are specified by three points, \code{p1}, \code{p2}, \code{p3}, meaning
a line from \code{p1} to \code{p2}, and another line from \code{p2} to \code{p3}.
}
\examples{
# none yet
}
\seealso{
Other vector diagrams: 
\code{\link{Proj}()},
\code{\link{arc}()},
\code{\link{arrows3d}()},
\code{\link{circle3d}()},
\code{\link{plot.regvec3d}()},
\code{\link{pointOnLine}()},
\code{\link{regvec3d}()},
\code{\link{vectors}()},
\code{\link{vectors3d}()}
}
\concept{vector diagrams}
