% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle.R
\name{angle}
\alias{angle}
\title{Angle between two vectors}
\usage{
angle(x, y, degree = TRUE)
}
\arguments{
\item{x}{a numeric vector}

\item{y}{a numeric vector}

\item{degree}{logical; should the angle be computed in degrees? 
If \code{FALSE} the result is returned in radians}
}
\value{
a scalar containing the angle between the vectors
}
\description{
\code{angle} calculates the angle between two vectors.
}
\examples{
x <- c(2,1)
y <- c(1,1)
angle(x, y) # degrees
angle(x, y, degree = FALSE) # radians

# visually
xlim <- c(0,2.5)
ylim <- c(0,2)
# proper geometry requires asp=1
plot( xlim, ylim, type="n", xlab="X", ylab="Y", asp=1,
  main = expression(theta == 18.4))
abline(v=0, h=0, col="gray")
vectors(rbind(x,y), col=c("red", "blue"), cex.lab=c(2, 2)) 
text(.5, .37, expression(theta))


####
x <- c(-2,1)
y <- c(1,1)
angle(x, y) # degrees
angle(x, y, degree = FALSE) # radians

# visually
xlim <- c(-2,1.5)
ylim <- c(0,2)
# proper geometry requires asp=1
plot( xlim, ylim, type="n", xlab="X", ylab="Y", asp=1,
  main = expression(theta == 108.4))
abline(v=0, h=0, col="gray")
vectors(rbind(x,y), col=c("red", "blue"), cex.lab=c(2, 2)) 
text(0, .4, expression(theta), cex=1.5)
}
\seealso{
\code{\link{len}}
}
