% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowops.R
\name{rowadd}
\alias{rowadd}
\title{Add multiples of rows to other rows}
\usage{
rowadd(x, from, to, mult)
}
\arguments{
\item{x}{a numeric matrix, possibly consisting of the coefficient matrix, A, joined with a vector of constants, b.}

\item{from}{the index of one or more source rows. If \code{from} is a vector, it must have the same length as \code{to}.}

\item{to}{the index of one or more destination rows}

\item{mult}{the multiplier(s)}
}
\value{
the matrix \code{x}, as modified
}
\description{
The elementary row operation \code{rowadd} adds multiples of one or more rows to other rows of a matrix.
This is usually used as a means to solve systems of linear equations, of the form \eqn{A x = b}, and \code{rowadd}
corresponds to adding equals to equals.
}
\details{
The functions \code{\link{rowmult}} and \code{\link{rowswap}} complete the basic operations used in reduction
to row echelon form and Gaussian elimination. These functions are used for demonstration purposes.
}
\examples{
A <- matrix(c(2, 1, -1,
             -3, -1, 2,
             -2,  1, 2), 3, 3, byrow=TRUE)
b <- c(8, -11, -3)

# using row operations to reduce below diagonal to 0
Ab <- cbind(A, b)
(Ab <- rowadd(Ab, 1, 2, 3/2))  # row 2 <- row 2 + 3/2 row 1
(Ab <- rowadd(Ab, 1, 3, 1))    # row 3 <- row 3 + 1 row 1
(Ab <- rowadd(Ab, 2, 3, -4))   # row 3 <- row 3 - 4 row 2
# multiply to make diagonals = 1
(Ab <- rowmult(Ab, 1:3, c(1/2, 2, -1)))
# The matrix is now in triangular form

# Could continue to reduce above diagonal to zero
echelon(A, b, verbose=TRUE, fractions=TRUE)

}
\seealso{
\code{\link{echelon}}, \code{\link{gaussianElimination}}

Other elementary row operations: \code{\link{rowmult}},
  \code{\link{rowswap}}
}

