% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showeqn.R
\name{showEqn}
\alias{showEqn}
\title{Show Matrices (A, b) as Linear Equations}
\usage{
showEqn(A, b, vars, simplify = FALSE, latex = FALSE)
}
\arguments{
\item{A}{either the matrix of coefficients of a system of linear equations, or the matrix \code{cbind(A,b)}}

\item{b}{if supplied, the vector of constants on the right hand side of the equations}

\item{vars}{a numeric or character vector of names of the variables.
If supplied, the length must be equal to the number of unknowns in the equations.
The default is \code{paste0("x", 1:ncol(A)}.}

\item{simplify}{logical; try to simplify the equations?}

\item{latex}{logical; print equations in a form suitable for LaTeX output?}
}
\value{
a one-column character matrix, one row for each equation
}
\description{
Shows what matrices \eqn{A, b} look like as the system of linear equations, \eqn{A x = b}, but written out
as a set of equations.
}
\examples{
  A <- matrix(c(2, 1, -1,
               -3, -1, 2,
               -2,  1, 2), 3, 3, byrow=TRUE)
  b <- c(8, -11, -3)
  showEqn(A, b)
  # show numerically
  x <- solve(A, b)
  showEqn(A, b, vars=x)

  showEqn(A, b, simplify=TRUE)
  showEqn(A, b, latex=TRUE)
}
\author{
Michael Friendly
}
\seealso{
\code{\link{plotEqn}}, \code{\link{plotEqn3d}}
}

