% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proj.R
\name{Proj}
\alias{Proj}
\title{Projection of Vector y on columns of X}
\usage{
Proj(y, X, list = FALSE)
}
\arguments{
\item{y}{a vector, treated as a one-column matrix}

\item{X}{a vector or matrix.  Number of rows of \code{y} and \code{X} must match}

\item{list}{logical; if FALSE, return just the projected vector; otherwise returns a list}
}
\value{
the projection of \code{y} on \code{X} (if \code{list=FALSE}) or a list with elements \code{y} and \code{P}
}
\description{
Fitting a linear model, \code{lm(y ~ X)}, by least squares can be thought of geometrically as the orthogonal projection of
\code{y} on the column space of \code{X}. This function is designed to allow exploration of projections
and orthogonality.
}
\details{
The projection is defined as \eqn{P y} where \eqn{P = X (X'X)^- X'}
and \eqn{X^-} is a generalized inverse.
}
\examples{
X <- matrix( c(1, 1, 1, 1, 1, -1, 1, -1), 4,2, byrow=TRUE)
y <- 1:4
Proj(y, X[,1])  # project y on unit vector
Proj(y, X[,2])
Proj(y, X)

# orthogonal complements
yp <-Proj(y, X, list=TRUE)
yp$y
P <- yp$P
IP <- diag(4) - P
yc <- c(IP \%*\% y)
crossprod(yp$y, yc)

# P is idempotent:  P P = P
P \%*\% P
all.equal(P, P \%*\% P)
}
\author{
Michael Friendly
}
\seealso{
Other vector diagrams: \code{\link{arrows3d}},
  \code{\link{corner}}, \code{\link{point_on_line}},
  \code{\link{vectors3d}}, \code{\link{vectors}}
}

