% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEqn.R
\name{plotEqn3d}
\alias{plotEqn3d}
\title{Plot Linear Equations in 3D}
\usage{
plotEqn3d(A, b, vars, xlim = c(-2, 2), ylim = c(-2, 2), zlim,
  col = 2:(nrow(A) + 1), alpha = 0.5, labels = FALSE, solution = TRUE)
}
\arguments{
\item{A}{either the matrix of coefficients of a system of linear equations, or the matrix \code{cbind(A,b)}
The \code{A} matrix must have three columns.}

\item{b}{if supplied, the vector of constants on the right hand side of the equations, of length matching
the number of rows of \code{A}.}

\item{vars}{a numeric or character vector of names of the variables.
If supplied, the length must be equal to the number of unknowns in the equations.
The default is \code{paste0("x", 1:ncol(A)}.}

\item{xlim}{axis limits for the first variable}

\item{ylim}{axis limits for the second variable}

\item{zlim}{horizontal axis limits for the second variable; if missing, \code{zlim} is calculated from the
range of the set of equations over the \code{xlim} and \code{ylim}}

\item{col}{scalar or vector of colors for the lines, recycled as necessary}

\item{alpha}{transparency applied to each plane}

\item{labels}{logical, or a vector of character labels for the equations; not yet implemented.}

\item{solution}{logical; should the solution point for all equations be marked (if possible)}
}
\value{
nothing; used for the side effect of making a plot
}
\description{
Shows what matrices \eqn{A, b} look like as the system of linear equations, \eqn{A x = b} with three unknowns,
x1, x2, and x3, by plotting a plane for each equation.
}
\examples{
# three consistent equations in three unknowns
A <- matrix(c(13, -4, 2, -4, 11, -2, 2, -2, 8), 3,3)
b <- c(1,2,4)
plotEqn3d(A,b)
}

