% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxt.R
\name{mxt}
\alias{mxt}
\alias{dmxt}
\alias{rmxt}
\title{Matrix Variate t-Distribution}
\usage{
dmxt(X, df, M = array(0, c(p, m)), U = diag(nrow(M)), V = diag(ncol(M)))

rmxt(n, df, M, U = diag(nrow(M)), V = diag(ncol(M)))
}
\arguments{
\item{X}{a \code{(p-by-m)} matrix whose density be computed.}

\item{df}{degrees of freedom.}

\item{M}{a \code{(p-by-n)} mean matrix.}

\item{U}{a \code{(p-by-p)} \emph{left} spread matrix.}

\item{V}{an \code{(n-by-n)} \emph{right} spread matrix.}

\item{n}{the number of samples to be generated.}
}
\description{
Functions \code{dmxt} and \code{rmxt} are for evaluating
densities and generating random samples from corresponding matrix
variate t-distribution.
}
\examples{
## generate 5 samples from {M,U,V = diag()} of df = 10
st5 = rmxt(5, df=10, M=diag(3))

## evaluate density for the 3rd sample
dmxt(st5[,,3], df=10, M=diag(3))

}
