% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlogit.data.R
\name{xlogit.data}
\alias{xlogit.data}
\title{data.frame for exploded logit model}
\usage{
xlogit.data(data, choice, shape = c("wide", "long"), varying = NULL,
  sep = ".", alt.var = NULL, chid.var = NULL, alt.levels = NULL,
  id.var = NULL, opposite = NULL, drop.index = FALSE,
  ranked = FALSE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{choice}{the variable indicating the choice made: it can be either a logical vector, a numerical vector with 0 where the alternative is not chosen, a factor with level 'yes' when the alternative is chosen}

\item{shape}{the shape of the data.frame: whether long if each row is an alternative or wide if each row is an observation}

\item{varying}{the indexes of the variables that are alternative specific}

\item{sep}{the seperator of the variable name and the alternative name (only relevant for a wide data.frame)}

\item{alt.var}{the name of the variable that contains the alternative index (for a long data.frame only) or the name under which the alternative index will be stored (the default name is alt)}

\item{chid.var}{the name of the variable that contains the choice index or the name under which the choice index will be stored}

\item{alt.levels}{the name of the alternatives: if null, for a wide data.frame, they are guessed from the variable names and the choice variable (both should be the same), for a long data.frame, they are guessed from the alt.var argument}

\item{id.var}{the name of the variable that contains the individual index if any}

\item{opposite}{returns the opposite of the specified variables}

\item{drop.index}{should the index variables be dropped from the data.frame}

\item{ranked}{a logical value which is true if the response is a rank}

\item{...}{further arguments passed to reshape}
}
\value{
\code{xlogit.data} returns a mlogit.data object, which is a data.frame in long format, i.e. one line for each alternative. It has a index attribute, which is a data.frame that contains the index of the choice made ('chid'), the index of the alternative ('alt') and, if any, the index of the individual ('id'). The choice variable is a boolean which indicates the choice made. This function use reshape if the data.frame is in wide format.
}
\description{
shape a data.frame in a suitable form for the use of the exploded logit with the mlogit function in package mlogit.
}
\examples{
\dontrun{
## Game2 is a data.frame in long format for which the response is a
## ranking variable (see example in package mlogit, function mlogit.data)

## --- 1. baseline case (equivalent to mlogit package)

## load data
data("Game2", package = "mlogit")
head(Game2, 13)

## transform data
G <- xlogit.data(Game2, shape = "long", choice = "ch", 
                 alt.var = "platform", ranked = TRUE)
head(G, 30)

## --- 2. handle missing values 

## introduce NAs
Game2$ch[Game2$ch != 1] <- NA

## transform data
G <- xlogit.data(Game2, shape = "long", choice = "ch", alt.var = "platform", ranked = TRUE)
head(G, 30)

## --- 3. handle varying choice sets 

## drop choice options
Game2 <- Game2[-c(7:8),]

## transform data
G <- xlogit.data(Game2, shape = "long", choice = "ch", alt.var = "platform", ranked = TRUE)
head(G, 30)

## --- 4. run models
summary(mlogit::mlogit(ch ~ own | -1 + hours + age, G, reflevel = "PC"))
summary(mlogit::mlogit(ch ~ 0 | -1 + age | own, G))
summary(mlogit::mlogit(ch ~ 0 | -1 + age, G))
}
}
\author{
Thilo Klein
}
\keyword{generate}
