/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TFloatLongHashMap;
import gnu.trove.TFloatLongIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFloatLongHashMapDecorator
extends AbstractMap<Float, Long>
implements Map<Float, Long>,
Externalizable,
Cloneable {
    protected TFloatLongHashMap _map;

    public TFloatLongHashMapDecorator() {
    }

    public TFloatLongHashMapDecorator(TFloatLongHashMap map) {
        this._map = map;
    }

    public TFloatLongHashMap getMap() {
        return this._map;
    }

    @Override
    public TFloatLongHashMapDecorator clone() {
        try {
            TFloatLongHashMapDecorator copy = (TFloatLongHashMapDecorator)super.clone();
            copy._map = (TFloatLongHashMap)this._map.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public Long put(Float key, Long value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public Long get(Float key) {
        float k = this.unwrapKey(key);
        long v = this._map.get(k);
        if (v == 0L) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Long remove(Float key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Set<Map.Entry<Float, Long>> entrySet() {
        return new AbstractSet<Map.Entry<Float, Long>>(){

            @Override
            public int size() {
                return TFloatLongHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TFloatLongHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TFloatLongHashMapDecorator.this.containsKey(k) && ((Long)TFloatLongHashMapDecorator.this.get(k)).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Float, Long>> iterator() {
                return new Iterator<Map.Entry<Float, Long>>(){
                    private final TFloatLongIterator it;
                    {
                        this.it = TFloatLongHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Float, Long> next() {
                        this.it.advance();
                        final Float key = TFloatLongHashMapDecorator.this.wrapKey(this.it.key());
                        final Long v = TFloatLongHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Float, Long>(){
                            private Long val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Float getKey() {
                                return key;
                            }

                            @Override
                            public Long getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Long setValue(Long value) {
                                this.val = value;
                                return TFloatLongHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Long o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Float, Long>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TFloatLongHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Long> map) {
        Iterator<Map.Entry<? extends Float, ? extends Long>> it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry<? extends Float, ? extends Long> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Float wrapKey(float k) {
        return Float.valueOf(k);
    }

    protected float unwrapKey(Object key) {
        return ((Float)key).floatValue();
    }

    protected Long wrapValue(long k) {
        return k;
    }

    protected long unwrapValue(Object value) {
        return (Long)value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._map = (TFloatLongHashMap)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this._map);
    }
}

