/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.opres.ssp;

import choco.kernel.common.opres.ssp.AbstractSubsetSumSolver;
import choco.kernel.solver.SolverException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class BellmanWithLists
extends AbstractSubsetSumSolver {
    private int[] setX;
    private final LinkedList<Integer> reachables = new LinkedList();

    public BellmanWithLists(int[] sizes, int capacity) {
        super(sizes, capacity);
    }

    @Override
    public void reset() {
        super.reset();
        this.reachables.clear();
        Arrays.fill(this.setX, -1);
    }

    @Override
    public void setCapacity(Long capacity) {
        if (!capacity.equals(this.capacity)) {
            this.setX = new int[Long.valueOf(capacity).intValue() + 1];
            Arrays.fill(this.setX, -1);
        }
        super.setCapacity(capacity);
    }

    @Override
    public String getName() {
        return "Bellman with lists";
    }

    @Override
    public long run() {
        this.reachables.add(0);
        for (int item = 0; item < this.sizes.length; ++item) {
            this.handleItem(item);
            if (this.setX[this.capacity.intValue()] != -1) break;
        }
        this.objective = this.reachables.getLast().intValue();
        return this.objective;
    }

    @Override
    public BitSet getSolution() {
        int cpt;
        BitSet solution = new BitSet(this.sizes.length);
        for (cpt = Long.valueOf(this.objective).intValue(); cpt > 0; cpt -= this.sizes[this.setX[cpt]]) {
            solution.set(cpt);
        }
        if (cpt != 0) {
            throw new SolverException("internal error of " + this.getName());
        }
        return solution;
    }

    public final BitSet getCoveredSet() {
        BitSet res = new BitSet(this.capacity.intValue() + 1);
        for (Integer r : this.reachables) {
            res.set(r);
        }
        return res;
    }

    public void handleItem(int item) {
        LinkedList<Integer> tmp = new LinkedList<Integer>();
        ListIterator old = this.reachables.listIterator();
        while (old.hasNext()) {
            Integer current = (Integer)old.next();
            old.previous();
            while (!tmp.isEmpty() && (Integer)tmp.getFirst() < current) {
                old.add(tmp.removeFirst());
            }
            old.next();
            Integer value = current + this.sizes[item];
            if ((long)value.intValue() > this.capacity || this.setX[value] != -1) continue;
            tmp.add(value);
            this.setX[value.intValue()] = item;
        }
        this.reachables.addAll(tmp);
    }
}

