/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.variables.integer;

import choco.cp.common.util.iterators.IntDomainIterator;
import choco.cp.solver.variables.delta.StackDeltaDomain;
import choco.cp.solver.variables.integer.AbstractIntDomain;
import choco.cp.solver.variables.integer.IntDomainVarImpl;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBinaryTree;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.propagation.PropagationEngine;
import java.util.ArrayList;
import java.util.Random;

public final class IntervalBTreeDomain
extends AbstractIntDomain {
    private static final Random random = new Random(System.currentTimeMillis());
    private final IStateBinaryTree btree;
    private final IStateInt size;
    private final int capacity;
    protected IntDomainIterator _iterator;

    public IntervalBTreeDomain(IntDomainVarImpl v, int a, int b, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        this.btree = environment.makeBinaryTree(a, b);
        this.capacity = b - a + 1;
        this.size = environment.makeInt(this.capacity);
        this.deltaDom = new StackDeltaDomain();
    }

    public IntervalBTreeDomain(IntDomainVarImpl v, int[] sortedValues, IEnvironment environment, PropagationEngine propagationEngine) {
        super(v, propagationEngine);
        int a = sortedValues[0];
        this.btree = environment.makeBinaryTree(a, a);
        this.capacity = sortedValues.length;
        IStateBinaryTree.Node n = this.btree.getRoot();
        for (int i = 1; i < this.capacity; ++i) {
            int b = sortedValues[i];
            if (b == a + 1) {
                n.setSup(b);
            } else {
                n = new IStateBinaryTree.Node(this.btree, b, b);
                this.btree.add(n, false);
            }
            a = b;
        }
        this.size = environment.makeInt(this.btree.getSize());
        this.deltaDom = new StackDeltaDomain();
    }

    @Override
    public int getInf() {
        return this.btree.getFirstNode().inf;
    }

    @Override
    public int getSup() {
        return this.btree.getLastNode().sup;
    }

    @Override
    public int updateInf(int x) {
        for (int i = this.getInf(); i < x; ++i) {
            this.remove(i);
        }
        return this.getInf();
    }

    @Override
    public int updateSup(int x) {
        for (int i = this.getSup(); i > x; --i) {
            this.remove(i);
        }
        return this.getSup();
    }

    @Override
    public boolean contains(int x) {
        return this.btree.find(x) != null;
    }

    @Override
    public boolean remove(int x) {
        boolean b = this.btree.remove(x);
        if (b) {
            this.removeIndex(x);
            this.size.add(-1);
        }
        return b;
    }

    private void removeIndex(int i) {
        this.deltaDom.remove(i);
    }

    @Override
    public void restrict(int x) {
        IStateBinaryTree.Node current = this.btree.getRoot();
        while (current.leftNode != null) {
            this.btree.remove(current.leftNode);
        }
        while (current.rightNode != null) {
            this.btree.remove(current.rightNode);
        }
        this.btree.getRoot().setInf(x);
        this.btree.getRoot().setSup(x);
        this.size.set(1);
    }

    @Override
    public int getSize() {
        return this.size.get();
    }

    @Override
    public DisposableIntIterator getIterator() {
        if (this._iterator == null) {
            this._iterator = new IntDomainIterator();
        } else if (!this._iterator.reusable()) {
            this._iterator = new IntDomainIterator();
        }
        this._iterator.init(this);
        return this._iterator;
    }

    @Override
    public int getNextValue(int x) {
        IStateBinaryTree.Node n = this.btree.nextNode(x);
        if (n == null) {
            return Integer.MAX_VALUE;
        }
        if (n.contains(x + 1)) {
            return x + 1;
        }
        return n.getInf();
    }

    @Override
    public int getPrevValue(int x) {
        IStateBinaryTree.Node n = this.btree.prevNode(x);
        if (n == null) {
            return Integer.MIN_VALUE;
        }
        if (n.contains(x - 1)) {
            return x - 1;
        }
        return n.getSup();
    }

    @Override
    public boolean hasNextValue(int x) {
        return x < this.getSup();
    }

    @Override
    public boolean hasPrevValue(int x) {
        return x > this.getInf();
    }

    @Override
    public int getRandomValue() {
        ArrayList<IStateBinaryTree.Node> tmp = new ArrayList<IStateBinaryTree.Node>(16);
        IStateBinaryTree.Node current = this.btree.getRoot();
        while (current != null) {
            tmp.add(current);
            if (random.nextBoolean()) {
                current = current.leftNode;
                continue;
            }
            current = current.rightNode;
        }
        IStateBinaryTree.Node selected = (IStateBinaryTree.Node)tmp.get(random.nextInt(tmp.size()));
        int val = random.nextInt(selected.sup - selected.inf + 1);
        return val + selected.inf;
    }

    @Override
    public boolean isEnumerated() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public String pretty() {
        return ((Object)this.btree).toString();
    }

    @Override
    public String toString() {
        return ((Object)this.btree).toString();
    }
}

