% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_2C_mat.R
\name{match_2C_mat}
\alias{match_2C_mat}
\title{Perform a pair matching using two user-specified distance matrices.}
\usage{
match_2C_mat(
  Z,
  dataset,
  dist_mat_1,
  dist_mat_2,
  lambda,
  controls = 1,
  p_1 = NULL,
  caliper_1 = NULL,
  k_1 = NULL,
  p_2 = NULL,
  caliper_2 = NULL,
  k_2 = NULL,
  penalty = Inf,
  overflow = FALSE
)
}
\arguments{
\item{Z}{A length-n vector of treatment indicator.}

\item{dataset}{The original dataset.}

\item{dist_mat_1}{A user-specified treatment-by-control (n_t-by-n_c) distance matrix.}

\item{dist_mat_2}{A second user-specified treatment-by-control (n_t-by-n_c) distance matrix.}

\item{lambda}{A penalty that controls the trade-off between two parts of the network.}

\item{controls}{Number of controls matched to each treated.}

\item{p_1}{A length-n vector on which caliper_1 applies, e.g. a vector of propensity score.}

\item{caliper_1}{Size of caliper_1.}

\item{k_1}{Maximum number of controls each treated is connected to in the first network.}

\item{p_2}{A length-n vector on which caliper_2 applies, e.g. a vector of propensity score.}

\item{caliper_2}{Size of caliper_2.}

\item{k_2}{Maximum number of controls each treated is connected to in the second network.}

\item{penalty}{Penalty for violating the caliper. Set to Inf by default.}

\item{overflow}{A logical value indicating if overflow protection is turned on.}
}
\value{
This function returns a list of three objects including the feasibility
of the matching problem and the matched controls organized in different formats.
See the documentation of the function construct_outcome or the tutorial for more
details.
}
\description{
This function performs a pair-matching using two user-specified distance
matrices and two calipers. Typically one distance matrix is used to
minimize matched-pair differences, and a second distance matrix is used
to enforce constraints on marginal distributions of certain variables.
}
\details{
This function performs a pair matching via a two-part network.
The first part is a network whose treatment-to-control distance
matrix is supplied by dist_mat_1. The second part of the
network is constructed using distance matrix specified by dist_mat_2. Often,
the first part of the network is used to minimize total treated-to-control matched pair
distances, and the second part is used to enforce certain marginal constraints.

The function constructs two list representations of distance matrices, possibly
using the caliper. caliper_1 is applied to p_1 (caliper_2 applied to p_2) in order to
construct sparse list representations. For instance, a caliper equal to 0.2 (caliper_1 = 0.2)
applied to the propensity score (p_1).

lambda is a penalty, or a tuning parameter, that balances these two objectives. When lambda is
very large, the network will first minimize the second part of network and then the first part.
}
\examples{
\dontrun{
To run the following code, one needs to first install
and load the package optmatch.

# We first prepare the input X, Z, propensity score

#attach(dt_Rouse)
#X = cbind(female,black,bytest,dadeduc,momeduc,fincome)
#Z = IV
#propensity = glm(IV~female+black+bytest+dadeduc+momeduc+fincome,
#family=binomial)$fitted.values
#n_t = sum(Z)
#n_c = length(Z) - n_t
#dt_Rouse$propensity = propensity
#detach(dt_Rouse)

# Next, we use the match_on function in optmatch
to create two treated-by-control distance matrices.

#library(optmatch)
# dist_mat_1 = match_on(IV~female+black+bytest+dadeduc+momeduc+fincome,
# method = 'mahalanobis', data = dt_Rouse)

# dist_mat_2 = match_on(IV ~ female, method = 'euclidean', data = dt_Rouse)


# Feed two distance matrices to the function match_2C_mat without caliper
# and a large penalty lambda to enforce (near-)fine balance.

#matching_output = match_2C_mat(Z, dt_Rouse, dist_mat_1, dist_mat_2,
#                               lambda = 10000, p_1 = NULL, p_2 = NULL)

# For more examples, please consult the RMarkdown tutorial.
}


}
