% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{get_mass_props_unc}
\alias{get_mass_props_unc}
\title{Get mass properties uncertainties for a row in a data frame}
\usage{
get_mass_props_unc(df, id)
}
\arguments{
\item{df}{A data frame  with (at least) these columns: \code{id}, \code{sigma_mass},
\code{sigma_Cx}, \code{sigma_Cy}, \code{sigma_Cz}, \code{sigma_Ixx}, \code{sigma_Iyy}, \code{sigma_Izz},
\code{sigma_Ixy}, \code{sigma_Ixz}, \code{sigma_Iyz}.}

\item{id}{The \code{id} value of the desired row.}
}
\value{
A list with the following named elements:
\itemize{
\item \code{sigma_mass} Numeric mass uncertainty.
\item \code{sigma_center_mass} Numeric 3-vector center of mass uncertainties.
\item \code{sigma_inertia} Numeric 3x3 matrix inertia tensor uncertainties.
}
}
\description{
\code{get_mass_props_unc()} creates a mass properties uncertainties list from a selected row in a data frame.
}
\examples{
get_mass_props_unc(mp_table, "C.1.2.2.3.1.2.3")

}
