% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/massprops.R
\name{set_mass_props_unc}
\alias{set_mass_props_unc}
\title{Set mass properties uncertainties for a row in a data frame}
\usage{
set_mass_props_unc(df, id, mpu)
}
\arguments{
\item{df}{A data frame with an \code{id} column.}

\item{id}{The \code{id} value of the desired row.}

\item{mpu}{A list with the following named elements:
\itemize{
\item \code{sigma_mass} Numeric mass uncertainty.
\item \code{sigma_center_mass} Numeric 3-vector center of mass uncertainties.
\item \code{sigma_inertia} Numeric 3x3 matrix inertia tensor uncertainties.
}}
}
\value{
The updated data frame.
}
\description{
\code{set_mass_props_unc()} sets mass properties and uncertainties for a
selected row in a data frame with an \code{id} column.
}
\examples{
set_mass_props_unc(sawe_table, "Combined", get_mass_props_unc(sawe_table, "Widget"))

}
