% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R, R/market_fit.R
\name{model_description}
\alias{model_description}
\alias{name}
\alias{describe}
\alias{market_type}
\alias{name,market_model-method}
\alias{describe,market_model-method}
\alias{market_type,market_model-method}
\alias{name,market_fit-method}
\alias{describe,market_fit-method}
\alias{market_type,market_fit-method}
\title{Short model and market descriptions}
\usage{
name(object)

describe(object)

market_type(object)

\S4method{name}{market_model}(object)

\S4method{describe}{market_model}(object)

\S4method{market_type}{market_model}(object)

\S4method{name}{market_fit}(object)

\S4method{describe}{market_fit}(object)

\S4method{market_type}{market_fit}(object)
}
\arguments{
\item{object}{A model object.}
}
\value{
A string representation of the model.

A model description string.

A string representation of the model.
}
\description{
A unique identifying string for the model.

A short (one-liner) description of the market model.

A market type string (equilibrium or disequilibrium) for a given model.
}
\examples{
# initialize the equilibrium using the houses dataset
model <- new(
  "equilibrium_model", # model type
  subject = ID, time = TREND, quantity = HS, price = RM,
  demand = RM + TREND + W + CSHS + L1RM + L2RM + MONTH,
  supply = RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses()
)

name(model)
# initialize the basic model using the houses dataset
model <- new(
  "diseq_basic", # model type
  subject = ID, time = TREND, quantity = HS, price = RM,
  demand = RM + TREND + W + CSHS + L1RM + L2RM + MONTH,
  supply = RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses()
)

describe(model)
}
