% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RHMMLikelihood.r
\name{R_HMMLikelihood}
\alias{R_HMMLikelihood}
\alias{loglikelihood}
\title{Hidden Markov Model Functions}
\usage{
R_HMMLikelihood(x,first,m,T,dmat,gamma,delta)
       loglikelihood(object,ddl=NULL)
}
\arguments{
\item{x}{single observed sequence (capture history)}

\item{first}{occasion to initiate likelihood calculation for sequence}

\item{m}{number of states}

\item{T}{number of occasions; sequence length}

\item{dmat}{observation probability matrices}

\item{gamma}{transition matrices}

\item{delta}{initial distribution}

\item{object}{fitted hmm model}

\item{ddl}{design data list; will be computed if NULL}
}
\value{
both return log-likelihood, alpha, v and phi arrays
}
\description{
R implementation of HMMs described in processed report except function HMMLikelihood renamed to R_HMMLikelihood and changed to compute
values for all capture histories and return  lnl, alpha, phi, v, dmat, and gamma values. loglikelihood is called with a fitted hmm model
and then computes the gamma,dmat and delta matrices and calls R_HMMLikelihood function. These are not used by the fitting code.
}
\author{
Jeff Laake <jeff.laake@noaa.gov>
}
\references{
Zucchini, W. and I.L. MacDonald. 2009. Hidden Markov Models for Time Series: An Introduction using R. Chapman and Hall, Boca Raton, FL. 275p. See page 45.
}

