% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/defining.programs.R
\name{season.lagging}
\alias{season.lagging}
\title{season.lagging}
\usage{
season.lagging(y, lagging = NULL)
}
\arguments{
\item{y}{= data series}

\item{lagging}{= lagging array array describing what to be added
to y: c(1,3,6) adds a new y3, using y1 lagged 6 time steps.
lagging<-matrix(c(1,3,6-1,2,4,12-1),nrow=3) adds two new variables
(y3 and y4) using y1 lagged 6-1 time steps and y2 lagged 12-1 time
steps.}
}
\value{
y.lagged = the part of the new series (including new
lagged variables) that can be entered into marima

y.future = the part of the new series (including new
lagged variables) that does not include future observation

y.lost = previous values of the time series that is
incomplete with respect to the new variables generated by lagging

cbind(y.lost,y.lagged.y,y.future) is the complete series after
creation and addition of the lagged variables.
}
\description{
Generate new time series with (seasonally) lagged variables
from lagging pattern.
}
\examples{
set.seed(4711)
# generate bivariate time series
y<-round(matrix(10*rnorm(36),nrow=2))
y
# define new lagged variables (y3 and y4) with seasonalities 6 and 12
lagging <-c(1,3,(6-1), 2,4,(12-1)) #
season.lagging(y,lagging)
}

