% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dataset.R
\name{get_dataset}
\alias{get_dataset}
\title{Download and Read Datasets from \code{marginaleffects} or Rdatasets}
\usage{
get_dataset(dataset = "thornton", package = NULL, docs = FALSE, search = NULL)
}
\arguments{
\item{dataset}{String. Name of the dataset to download.
\itemize{
\item \code{marginaleffects} archive: \code{affairs}, \code{airbnb}, \code{ces_demographics}, \code{ces_survey}, \code{immigration}, \code{lottery}, \code{military}, \code{thornton}, \code{factorial_01}, \code{interaction_01}, \code{interaction_02}, \code{interaction_03}, \code{interaction_04}, \code{polynomial_01}, \code{polynomial_02}
\item Rdatasets archive: The name of a dataset listed on the Rdatasets index. See the website or the \code{search} argument.
}}

\item{package}{String. Package name that originally published the data.}

\item{docs}{Logical. If TRUE open the documentation using \code{getOption("viewer")} or the Rstudio viewer.}

\item{search}{Regular expression. Download the dataset index from Rdatasets; search the "Package", "Item", and "Title" columns; and return the matching rows.}
}
\value{
A data frame containing the dataset.
library(marginaleffects)
}
\description{
Downloads a dataset from the \code{marginaleffects} or the Rdatasets archives, and return it as a data frame. Opens the documentation as an HTML page. Search available datasets.

\url{https://vincentarelbundock.github.io/Rdatasets/}
}
\examples{
dat <- get_dataset("Titanic", "Stat2Data")
head(dat)

get_dataset(search = "(?i)titanic")

# View documentation in the browser
# get_dataset("Titanic", "Stat2Data", docs = TRUE)
}
