% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_routes.R
\name{extract_routes}
\alias{extract_routes}
\title{Extract *routes* from Google Maps Directions API response}
\usage{
extract_routes(doc)
}
\arguments{
\item{doc}{XML document with Google Maps Directions API response}
}
\value{
Line layer (class \code{sf}) representing routes
}
\description{
Extract *routes* from Google Maps Directions API response
}
\examples{
library(xml2)
doc = as_xml_document(response_directions)
r = extract_routes(doc)
plot(r)
\dontrun{
doc = google_directions(
  origin = c(34.81127, 31.89277),
  destination = c(34.781107, 32.085003),
  alternatives = TRUE
)
r = extract_routes(doc)
plot(r)
}
}
