% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{drop_marker}
\alias{drop_marker}
\title{Remove markers from a map}
\usage{
drop_marker(input.map, mrk, verbose = TRUE)
}
\arguments{
\item{input.map}{an object of class \code{mappoly.map}}

\item{mrk}{a vector containing markers to be removed from the input map, 
identified by their names or positions}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
an object of class \code{mappoly.map}
}
\description{
This function creates a new map by removing markers from an existing one.
}
\examples{
 sub.map <- get_submap(maps.hexafake[[1]], 1:50, reestimate.rf = FALSE)
 plot(sub.map, mrk.names = TRUE)
 mrk.to.remove <- c("M_1", "M_23", "M_34")
 red.map <- drop_marker(sub.map, mrk.to.remove)
 plot(red.map, mrk.names = TRUE)

}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
