% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reestimate_map_with_global_genotypic_error.R
\name{est_full_hmm_with_global_error}
\alias{est_full_hmm_with_global_error}
\title{Re-estimate genetic map given a global genotyping error}
\usage{
est_full_hmm_with_global_error(
  input.map,
  error = NULL,
  tol = 0.001,
  restricted = TRUE,
  th.prob = 0.95,
  verbose = FALSE
)
}
\arguments{
\item{input.map}{an object of class \code{mappoly.map}}

\item{error}{the assumed global error rate (default = NULL)}

\item{tol}{the desired accuracy (default = 10e-04)}

\item{restricted}{if \code{TRUE} (default), restricts the prior to the 
possible classes under Mendelian, non double-reduced segregation 
given dosage of the parents}

\item{th.prob}{the threshold for using global error or genotype 
probability distribution if present in the dataset (default = 0.95)}

\item{verbose}{if \code{TRUE}, current progress is shown; if
\code{FALSE} (default), no output is produced}
}
\value{
A list of class \code{mappoly.map} with two elements: 

i) info:  a list containing information about the map, regardless of the linkage phase configuration:
\item{ploidy}{the ploidy level}
\item{n.mrk}{number of markers}
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{mrk.names}{the names of markers in the map}
\item{seq.dose.p1}{a vector containing the dosage in parent 1 for all markers in the map}
\item{seq.dose.p2}{a vector containing the dosage in parent 2 for all markers in the map}
\item{chrom}{a vector indicating the sequence (usually chromosome) each marker belongs 
                as informed in the input file. If not available, 
                \code{chrom = NULL}}
\item{genome.pos}{physical position (usually in megabase) of the markers into the sequence}
\item{seq.ref}{reference base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}                 
\item{seq.alt}{alternative base used for each marker (i.e. A, T, C, G). If not available, 
                \code{seq.ref = NULL}}
\item{chisq.pval}{a vector containing p-values of the chi-squared test of Mendelian 
                  segregation for all markers in the map}                 
\item{data.name}{name of the dataset of class \code{mappoly.data}}
\item{ph.thres}{the LOD threshold used to define the linkage phase configurations to test}

ii) a list of maps with possible linkage phase configuration. Each map in the list is also a 
   list containing
\item{seq.num}{a vector containing the (ordered) indices of markers in the map, 
               according to the input file}
\item{seq.rf}{a vector of size (\code{n.mrk - 1}) containing a sequence of recombination 
              fraction between the adjacent markers in the map}
\item{seq.ph}{linkage phase configuration for all markers in both parents}
\item{loglike}{the hmm-based multipoint likelihood}
}
\description{
This function considers a global error when re-estimating
a genetic map using Hidden Markov models. Since this function 
uses the whole transition space in the HMM, its computation 
can take a while, especially for hexaploid maps.
}
\examples{
    submap <- get_submap(solcap.dose.map[[1]], mrk.pos = 1:20, verbose = FALSE)
    err.submap <- est_full_hmm_with_global_error(submap, 
                                                 error = 0.01, 
                                                 tol = 10e-4, 
                                                 verbose = TRUE)
    err.submap
    plot_map_list(list(dose = submap, err = err.submap), 
                  title = "estimation procedure")

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
