% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_from_updog.R
\name{import_from_updog}
\alias{import_from_updog}
\title{Import from updog}
\usage{
import_from_updog(
  object,
  prob.thres = 0.95,
  filter.non.conforming = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{the name of the object of class \code{multidog}}

\item{prob.thres}{probability threshold to associate a marker call to a 
dosage. Markers with maximum genotype probability smaller than 'prob.thres' 
are considered as missing data for the dosage calling purposes}

\item{filter.non.conforming}{if \code{TRUE} (default) exclude samples with non 
expected genotypes under random chromosome pairing and no double reduction}

\item{verbose}{if \code{TRUE} (default), the current progress is shown; if
\code{FALSE}, no output is produced}
}
\value{
An object of class \code{mappoly.data} which contains a
    list with the following components:
    \item{ploidy}{ploidy level}
    \item{n.ind}{number individuals}
    \item{n.mrk}{total number of markers}
    \item{ind.names}{the names of the individuals}
    \item{mrk.names}{the names of the markers}
    \item{dosage.p1}{a vector containing the dosage in
      parent P for all \code{n.mrk} markers}
    \item{dosage.p2}{a vector containing the dosage in
      parent Q for all \code{n.mrk} markers}
    \item{chrom}{a vector indicating which sequence each marker
      belongs. Zero indicates that the marker was not assigned to any
      sequence}
    \item{genome.pos}{physical position of the markers into the
      sequence}
    \item{prob.thres}{probability threshold to associate a marker call to a 
    dosage. Markers with maximum genotype probability smaller than 'prob.thres' 
    were considered as missing data in the 'geno.dose' matrix}
    \item{geno.dose}{a matrix containing the dosage for each markers (rows) 
      for each individual (columns). Missing data are represented by 
      \code{ploidy_level + 1}}
    \item{geno}{a data.frame 
      containing the probability distribution for each combination of
      marker and offspring. The first two columns represent the marker
      and the offspring, respectively. The remaining elements represent
      the probability associated to each one of the possible
      dosages. Missing data are converted from \code{NA} to the expected
      segregation ratio using function \code{\link[mappoly]{segreg_poly}}}
    \item{n.phen}{number of phenotypic traits}
    \item{phen}{a matrix containing the phenotypic data. The rows
                correspond to the traits and the columns correspond
                to the individuals}
    \item{chisq.pval}{a vector containing p-values related to the chi-squared 
    test of Mendelian segregation performed for all markers}
}
\description{
Read objects with information related to genotype calling in polyploids.
Currently this function supports output objects created with the
\code{updog} (output of \code{multidog} function) package.
This function creates an object of class \code{mappoly.data}
}
\examples{
\donttest{
if(requireNamespace("updog", quietly = TRUE)){
library("updog")
data("uitdewilligen")
mout = multidog(refmat = t(uitdewilligen$refmat), 
                sizemat = t(uitdewilligen$sizemat), 
                ploidy = uitdewilligen$ploidy, 
                model = "f1",
                p1_id = colnames(t(uitdewilligen$sizemat))[1],
                p2_id = colnames(t(uitdewilligen$sizemat))[2],
                nc = 2)
mydata = import_from_updog(mout)
mydata
plot(mydata)
}
}

}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \doi{10.1534/g3.119.400378}
}
\author{
Gabriel Gesteira, \email{gabrielgesteira@usp.br}
}
