context("Homolog probability")
test_that("computes homolog probabilities correctly", {
  x1 <- get_submap(solcap.dose.map[[1]], 1:20, reestimate.rf = F)
  probs.t1<-calc_genoprob(input.map = x1,
                         verbose = TRUE)
  expect_equal(var(probs.t1$probs), 0.0153, tolerance = 1e-3)
  hom.t1 <- calc_homoprob(input.genoprobs = probs.t1)
  expect_equal(var(hom.t1$homoprob$probability), 0.187, tolerance = 1e-3)
  skip_if_not(capabilities("long.double"))
  expect_is(plot(hom.t1), "plotly")
  skip_if_not(capabilities("long.double"))
  expect_is(plot(hom.t1, stack = T), "plotly")
  skip_if_not(capabilities("long.double"))
  expect_is(plot(hom.t1, use.plotly = FALSE), "ggplot")
})