% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_phase_configurations.R
\name{ls_linkage_phases}
\alias{ls_linkage_phases}
\alias{print.two.pts.linkage.phases}
\alias{plot.two.pts.linkage.phases}
\title{List of linkage phases}
\usage{
ls_linkage_phases(input.seq, thres, twopt, mrk.to.add = NULL, prev.info = NULL)

\method{print}{two.pts.linkage.phases}(x, ...)

\method{plot}{two.pts.linkage.phases}(x, ...)
}
\arguments{
\item{input.seq}{an object of class \code{mappoly.sequence}}

\item{thres}{the LOD threshold used to determine whether linkage phases
compared via two-point analysis should be considered}

\item{twopt}{an object of class \code{poly.est.two.pts.pairwise}
containing the two-point information}

\item{mrk.to.add}{marker to be added to the end of the linkage
group. If \code{NULL} (default) adds all markers contained in
\code{input.seq}. Mostly for internal usage}

\item{prev.info}{(optional) an object of class \code{two.pts.linkage.phases}
containing the previous info about linkage phase configuration.
Mostly for internal usage}

\item{x}{an object of the class \code{two.pts.linkage.phases}}

\item{...}{currently ignored}
}
\value{
An object of class \code{two.pts.linkage.phases} which
    contains the following structure: 
    \item{config.to.test}{a matrix with all possible linkage phase configurations
     for both parents, P and Q} 
    \item{rec.frac}{a matrix with all recombination fractions}
    \item{m}{the ploidy level}
    \item{seq.num}{the sequence of markers}
    \item{thres}{the LOD threshold}
    \item{data.name}{the dataset name}
}
\description{
Returns a list of possible linkage phase configurations using
the two-point information contained in the object \code{poly.est.two.pts.pairwise}
as elimination criteria
}
\examples{
seq.all.mrk <- make_seq_mappoly(hexafake, 'all')
id <- get_genomic_order(seq.all.mrk)
seq10 <- make_seq_mappoly(hexafake, rownames(id)[1:10])
twopt<-est_pairwise_rf(seq10)

## Using the first 10 markers 
l10.seq.3.0 <- ls_linkage_phases(input.seq = seq10, thres = 3, twopt = twopt)
l10.seq.3.0
plot(l10.seq.3.0)
l10.seq.2.0 <- ls_linkage_phases(input.seq = seq10, thres = 2.0, twopt = twopt)
l10.seq.2.0
plot(l10.seq.2.0)
l10.seq.1.0 <- ls_linkage_phases(input.seq = seq10, thres = 1.0, twopt = twopt)
l10.seq.1.0
plot(l10.seq.1.0)

## Using the first 5 markers 
seq5 <- make_seq_mappoly(hexafake, rownames(id)[1:5])
l5.seq.5.0 <- ls_linkage_phases(input.seq = seq5, thres = 5, twopt = twopt)
l5.seq.5.0
plot(l5.seq.5.0)
l5.seq.3.0 <- ls_linkage_phases(input.seq = seq5, thres = 3, twopt = twopt)
l5.seq.3.0
plot(l5.seq.3.0)
l5.seq.1.0 <- ls_linkage_phases(input.seq = seq5, thres = 1, twopt = twopt)
l5.seq.1.0
plot(l5.seq.1.0)
}
\references{
Mollinari, M., and Garcia, A.  A. F. (2019) Linkage
    analysis and haplotype phasing in experimental autopolyploid
    populations with high ploidy level using hidden Markov
    models, _G3: Genes, Genomes, Genetics_. 
    \url{https://doi.org/10.1534/g3.119.400378}
}
\author{
Marcelo Mollinari, \email{mmollin@ncsu.edu}
}
\keyword{internal}
