% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/art_studio.R
\name{cymapper}
\alias{cymapper}
\title{Open mapper graph in Cytoscape}
\usage{
cymapper(mapperobject)
}
\arguments{
\item{mapperobject}{A set of data frames representing a mapper object, returned by, say, \code{\link[=create_mapper_object]{create_mapper_object()}}.}
}
\value{
Nothing; opens Cytoscape with information from the mapper object ported there. Cytoscape must be actively running in the background for this method to work.
}
\description{
Open mapper graph in Cytoscape
}
\examples{
\dontrun{
# this example requires Cytoscape to be open and running in the background to work properly

data = data.frame(x = sapply(1:100, function(x) cos(x)), y = sapply(1:100, function(x) sin(x)))
projx = data$x

num_bins = 10
percent_overlap = 25

cover = get_width_balanced_cover(min(projx), max(projx), num_bins, percent_overlap)

mapperobj = create_1D_mapper_object(data, dist(data), projx, cover, "single")
cymapper(mapperobj)
}
}
