% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{upload_tiles}
\alias{upload_tiles}
\title{Upload dataset to your Mapbox account}
\usage{
upload_tiles(
  input,
  username,
  access_token = NULL,
  tileset_id = NULL,
  tileset_name = NULL,
  keep_geojson = FALSE,
  multipart = FALSE
)
}
\arguments{
\item{input}{An sf object, or the path to the dataset to upload as a character string.}

\item{username}{Your Mapbox username}

\item{access_token}{Your Mapbox access token; must have secret scope}

\item{tileset_id}{The ID of the tileset in your Mapbox account}

\item{tileset_name}{The name of the tileset in your Mapbox account}

\item{keep_geojson}{Whether or not to keep the temporary GeoJSON used to generate the tiles (if the input is an sf object)}

\item{multipart}{Whether or not to upload to the temporary AWS staging bucket as a multipart object; defaults to \code{FALSE}.}
}
\description{
Upload dataset to your Mapbox account
}
\examples{
\dontrun{

# Example: create a tileset of median age for all United States Census tracts
# Requires setting a Mapbox secret access token as an environment variable

library(mapboxapi)
library(tidycensus)
options(tigris_use_cache = TRUE)

median_age <- get_acs(
  geography = "tract",
  variables = "B01002_001",
  state = c(state.abb, "DC"),
  geometry = TRUE
)

upload_tiles(
  input = median_age,
  username = "kwalkertcu", # Your username goes here
  tileset_id = "median_age",
  tileset_name = "us_median_age_2014_to_2018"
)
}

}
